# coding: utf-8

"""
    VulnCheck API

    Version 3 of the VulnCheck API

    The version of the OpenAPI document: 3.0
    Contact: support@vulncheck.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from vulncheck_sdk.models.advisory_ubuntu_package_release_status import AdvisoryUbuntuPackageReleaseStatus
from typing import Optional, Set
from typing_extensions import Self

class AdvisoryAffectedUbuntuPackage(BaseModel):
    """
    AdvisoryAffectedUbuntuPackage
    """ # noqa: E501
    break_commit_url: Optional[List[StrictStr]] = None
    fix_commit_url: Optional[List[StrictStr]] = None
    package_name: Optional[StrictStr] = None
    package_release_status: Optional[List[AdvisoryUbuntuPackageReleaseStatus]] = None
    upstream_fix_url: Optional[List[StrictStr]] = None
    __properties: ClassVar[List[str]] = ["break_commit_url", "fix_commit_url", "package_name", "package_release_status", "upstream_fix_url"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AdvisoryAffectedUbuntuPackage from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in package_release_status (list)
        _items = []
        if self.package_release_status:
            for _item_package_release_status in self.package_release_status:
                if _item_package_release_status:
                    _items.append(_item_package_release_status.to_dict())
            _dict['package_release_status'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AdvisoryAffectedUbuntuPackage from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "break_commit_url": obj.get("break_commit_url"),
            "fix_commit_url": obj.get("fix_commit_url"),
            "package_name": obj.get("package_name"),
            "package_release_status": [AdvisoryUbuntuPackageReleaseStatus.from_dict(_item) for _item in obj["package_release_status"]] if obj.get("package_release_status") is not None else None,
            "upstream_fix_url": obj.get("upstream_fix_url")
        })
        return _obj


