# coding: utf-8

"""
    VulnCheck API

    Version 3 of the VulnCheck API

    The version of the OpenAPI document: 3.0
    Contact: support@vulncheck.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from vulncheck_sdk.models.advisory_alma_date import AdvisoryAlmaDate
from vulncheck_sdk.models.advisory_alma_object_id import AdvisoryAlmaObjectID
from vulncheck_sdk.models.advisory_alma_package_list import AdvisoryAlmaPackageList
from vulncheck_sdk.models.advisory_alma_reference import AdvisoryAlmaReference
from typing import Optional, Set
from typing_extensions import Self

class AdvisoryAlmaLinuxUpdate(BaseModel):
    """
    AdvisoryAlmaLinuxUpdate
    """ # noqa: E501
    bs_repo_id: Optional[AdvisoryAlmaObjectID] = None
    cve: Optional[List[StrictStr]] = None
    date_added: Optional[StrictStr] = None
    description: Optional[StrictStr] = None
    fromstr: Optional[StrictStr] = None
    id: Optional[AdvisoryAlmaObjectID] = None
    issued_date: Optional[AdvisoryAlmaDate] = None
    pkglist: Optional[AdvisoryAlmaPackageList] = None
    pushcount: Optional[StrictStr] = None
    references: Optional[List[AdvisoryAlmaReference]] = None
    release: Optional[StrictStr] = None
    rights: Optional[StrictStr] = None
    severity: Optional[StrictStr] = None
    solution: Optional[StrictStr] = None
    status: Optional[StrictStr] = None
    summary: Optional[StrictStr] = None
    title: Optional[StrictStr] = None
    type: Optional[StrictStr] = None
    update_url: Optional[StrictStr] = None
    updated_date: Optional[AdvisoryAlmaDate] = None
    updateinfo_id: Optional[StrictStr] = None
    version: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["bs_repo_id", "cve", "date_added", "description", "fromstr", "id", "issued_date", "pkglist", "pushcount", "references", "release", "rights", "severity", "solution", "status", "summary", "title", "type", "update_url", "updated_date", "updateinfo_id", "version"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AdvisoryAlmaLinuxUpdate from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of bs_repo_id
        if self.bs_repo_id:
            _dict['bs_repo_id'] = self.bs_repo_id.to_dict()
        # override the default output from pydantic by calling `to_dict()` of id
        if self.id:
            _dict['id'] = self.id.to_dict()
        # override the default output from pydantic by calling `to_dict()` of issued_date
        if self.issued_date:
            _dict['issued_date'] = self.issued_date.to_dict()
        # override the default output from pydantic by calling `to_dict()` of pkglist
        if self.pkglist:
            _dict['pkglist'] = self.pkglist.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in references (list)
        _items = []
        if self.references:
            for _item_references in self.references:
                if _item_references:
                    _items.append(_item_references.to_dict())
            _dict['references'] = _items
        # override the default output from pydantic by calling `to_dict()` of updated_date
        if self.updated_date:
            _dict['updated_date'] = self.updated_date.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AdvisoryAlmaLinuxUpdate from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "bs_repo_id": AdvisoryAlmaObjectID.from_dict(obj["bs_repo_id"]) if obj.get("bs_repo_id") is not None else None,
            "cve": obj.get("cve"),
            "date_added": obj.get("date_added"),
            "description": obj.get("description"),
            "fromstr": obj.get("fromstr"),
            "id": AdvisoryAlmaObjectID.from_dict(obj["id"]) if obj.get("id") is not None else None,
            "issued_date": AdvisoryAlmaDate.from_dict(obj["issued_date"]) if obj.get("issued_date") is not None else None,
            "pkglist": AdvisoryAlmaPackageList.from_dict(obj["pkglist"]) if obj.get("pkglist") is not None else None,
            "pushcount": obj.get("pushcount"),
            "references": [AdvisoryAlmaReference.from_dict(_item) for _item in obj["references"]] if obj.get("references") is not None else None,
            "release": obj.get("release"),
            "rights": obj.get("rights"),
            "severity": obj.get("severity"),
            "solution": obj.get("solution"),
            "status": obj.get("status"),
            "summary": obj.get("summary"),
            "title": obj.get("title"),
            "type": obj.get("type"),
            "update_url": obj.get("update_url"),
            "updated_date": AdvisoryAlmaDate.from_dict(obj["updated_date"]) if obj.get("updated_date") is not None else None,
            "updateinfo_id": obj.get("updateinfo_id"),
            "version": obj.get("version")
        })
        return _obj


