# coding: utf-8

"""
    VulnCheck API

    Version 3 of the VulnCheck API

    The version of the OpenAPI document: 3.0
    Contact: support@vulncheck.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class AdvisoryClarotyVulnerability(BaseModel):
    """
    AdvisoryClarotyVulnerability
    """ # noqa: E501
    advisory_url: Optional[StrictStr] = None
    claroty_url: Optional[StrictStr] = None
    cve: Optional[List[StrictStr]] = None
    cvss_v3: Optional[Union[StrictFloat, StrictInt]] = None
    cwe: Optional[StrictStr] = None
    date_added: Optional[StrictStr] = None
    product: Optional[StrictStr] = None
    target: Optional[StrictStr] = None
    vendor: Optional[StrictStr] = None
    vendor_advisory_url: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["advisory_url", "claroty_url", "cve", "cvss_v3", "cwe", "date_added", "product", "target", "vendor", "vendor_advisory_url"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AdvisoryClarotyVulnerability from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AdvisoryClarotyVulnerability from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "advisory_url": obj.get("advisory_url"),
            "claroty_url": obj.get("claroty_url"),
            "cve": obj.get("cve"),
            "cvss_v3": obj.get("cvss_v3"),
            "cwe": obj.get("cwe"),
            "date_added": obj.get("date_added"),
            "product": obj.get("product"),
            "target": obj.get("target"),
            "vendor": obj.get("vendor"),
            "vendor_advisory_url": obj.get("vendor_advisory_url")
        })
        return _obj


