# coding: utf-8

"""
    VulnCheck API

    Version 3 of the VulnCheck API

    The version of the OpenAPI document: 3.0
    Contact: support@vulncheck.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from vulncheck_sdk.models.advisory_comm_vault_cve_details import AdvisoryCommVaultCVEDetails
from vulncheck_sdk.models.advisory_comm_vault_impacted_product import AdvisoryCommVaultImpactedProduct
from vulncheck_sdk.models.advisory_comm_vault_resolution import AdvisoryCommVaultResolution
from typing import Optional, Set
from typing_extensions import Self

class AdvisoryCommVault(BaseModel):
    """
    AdvisoryCommVault
    """ # noqa: E501
    cve: Optional[List[StrictStr]] = None
    cve_details: Optional[List[AdvisoryCommVaultCVEDetails]] = None
    cvss_range: Optional[StrictStr] = None
    date_added: Optional[StrictStr] = None
    description: Optional[StrictStr] = None
    id: Optional[StrictStr] = None
    impacted_product: Optional[AdvisoryCommVaultImpactedProduct] = None
    references: Optional[List[StrictStr]] = None
    resolution: Optional[AdvisoryCommVaultResolution] = None
    severity: Optional[StrictStr] = None
    title: Optional[StrictStr] = None
    updated_at: Optional[StrictStr] = None
    url: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["cve", "cve_details", "cvss_range", "date_added", "description", "id", "impacted_product", "references", "resolution", "severity", "title", "updated_at", "url"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AdvisoryCommVault from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in cve_details (list)
        _items = []
        if self.cve_details:
            for _item_cve_details in self.cve_details:
                if _item_cve_details:
                    _items.append(_item_cve_details.to_dict())
            _dict['cve_details'] = _items
        # override the default output from pydantic by calling `to_dict()` of impacted_product
        if self.impacted_product:
            _dict['impacted_product'] = self.impacted_product.to_dict()
        # override the default output from pydantic by calling `to_dict()` of resolution
        if self.resolution:
            _dict['resolution'] = self.resolution.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AdvisoryCommVault from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "cve": obj.get("cve"),
            "cve_details": [AdvisoryCommVaultCVEDetails.from_dict(_item) for _item in obj["cve_details"]] if obj.get("cve_details") is not None else None,
            "cvss_range": obj.get("cvss_range"),
            "date_added": obj.get("date_added"),
            "description": obj.get("description"),
            "id": obj.get("id"),
            "impacted_product": AdvisoryCommVaultImpactedProduct.from_dict(obj["impacted_product"]) if obj.get("impacted_product") is not None else None,
            "references": obj.get("references"),
            "resolution": AdvisoryCommVaultResolution.from_dict(obj["resolution"]) if obj.get("resolution") is not None else None,
            "severity": obj.get("severity"),
            "title": obj.get("title"),
            "updated_at": obj.get("updated_at"),
            "url": obj.get("url")
        })
        return _obj


