# coding: utf-8

"""
    VulnCheck API

    Version 3 of the VulnCheck API

    The version of the OpenAPI document: 3.0
    Contact: support@vulncheck.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from vulncheck_sdk.models.advisory_csaf_note import AdvisoryCSAFNote
from vulncheck_sdk.models.advisory_csaf_reference import AdvisoryCSAFReference
from vulncheck_sdk.models.advisory_csaf_score import AdvisoryCSAFScore
from vulncheck_sdk.models.advisory_cwe import AdvisoryCwe
from vulncheck_sdk.models.advisory_flag import AdvisoryFlag
from vulncheck_sdk.models.advisory_remediation_data import AdvisoryRemediationData
from vulncheck_sdk.models.advisory_threat_data import AdvisoryThreatData
from vulncheck_sdk.models.advisory_tracking_id import AdvisoryTrackingID
from typing import Optional, Set
from typing_extensions import Self

class AdvisoryCSAFVulnerability(BaseModel):
    """
    AdvisoryCSAFVulnerability
    """ # noqa: E501
    cve: Optional[StrictStr] = Field(default=None, description="MITRE standard Common Vulnerabilities and Exposures (CVE) tracking number for the vulnerability.  https://docs.oasis-open.org/csaf/csaf/v2.0/os/csaf-v2.0-os.html#3232-vulnerabilities-property---cve")
    cwe: Optional[AdvisoryCwe] = None
    flags: Optional[List[AdvisoryFlag]] = Field(default=None, description="Machine readable flags for products related to vulnerability  https://docs.oasis-open.org/csaf/csaf/v2.0/os/csaf-v2.0-os.html#3235-vulnerabilities-property---flags")
    ids: Optional[List[AdvisoryTrackingID]] = Field(default=None, description="List of IDs represents a list of unique labels or tracking IDs for the vulnerability (if such information exists).  https://docs.oasis-open.org/csaf/csaf/v2.0/os/csaf-v2.0-os.html#3236-vulnerabilities-property---ids")
    notes: Optional[List[AdvisoryCSAFNote]] = Field(default=None, description="Notes holds notes associated with the Vulnerability object. https://docs.oasis-open.org/csaf/csaf/v2.0/os/csaf-v2.0-os.html#3238-vulnerabilities-property---notes")
    product_status: Optional[Dict[str, List[StrictStr]]] = Field(default=None, description="Provide details on the status of the referenced product related to the vulnerability.  https://docs.oasis-open.org/csaf/csaf/v2.0/os/csaf-v2.0-os.html#3239-vulnerabilities-property---product-status")
    references: Optional[List[AdvisoryCSAFReference]] = Field(default=None, description="Vulnerability references holds a list of references associated with this vulnerability item.  https://docs.oasis-open.org/csaf/csaf/v2.0/os/csaf-v2.0-os.html#32310-vulnerabilities-property---references")
    release_date: Optional[StrictStr] = None
    remediations: Optional[List[AdvisoryRemediationData]] = Field(default=None, description="Provide details of remediations associated with a Vulnerability  https://docs.oasis-open.org/csaf/csaf/v2.0/os/csaf-v2.0-os.html#32312-vulnerabilities-property---remediations")
    scores: Optional[List[AdvisoryCSAFScore]] = Field(default=None, description="Scores holds the scores associated with the Vulnerability object. https://docs.oasis-open.org/csaf/csaf/v2.0/os/csaf-v2.0-os.html#32313-vulnerabilities-property---scores Currently only CVSS v3 is supported.")
    threats: Optional[List[AdvisoryThreatData]] = Field(default=None, description="Provide details of threats associated with a vulnerability.  https://docs.oasis-open.org/csaf/csaf/v2.0/os/csaf-v2.0-os.html#32314-vulnerabilities-property---threats")
    __properties: ClassVar[List[str]] = ["cve", "cwe", "flags", "ids", "notes", "product_status", "references", "release_date", "remediations", "scores", "threats"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AdvisoryCSAFVulnerability from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of cwe
        if self.cwe:
            _dict['cwe'] = self.cwe.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in flags (list)
        _items = []
        if self.flags:
            for _item_flags in self.flags:
                if _item_flags:
                    _items.append(_item_flags.to_dict())
            _dict['flags'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in ids (list)
        _items = []
        if self.ids:
            for _item_ids in self.ids:
                if _item_ids:
                    _items.append(_item_ids.to_dict())
            _dict['ids'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in notes (list)
        _items = []
        if self.notes:
            for _item_notes in self.notes:
                if _item_notes:
                    _items.append(_item_notes.to_dict())
            _dict['notes'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in references (list)
        _items = []
        if self.references:
            for _item_references in self.references:
                if _item_references:
                    _items.append(_item_references.to_dict())
            _dict['references'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in remediations (list)
        _items = []
        if self.remediations:
            for _item_remediations in self.remediations:
                if _item_remediations:
                    _items.append(_item_remediations.to_dict())
            _dict['remediations'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in scores (list)
        _items = []
        if self.scores:
            for _item_scores in self.scores:
                if _item_scores:
                    _items.append(_item_scores.to_dict())
            _dict['scores'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in threats (list)
        _items = []
        if self.threats:
            for _item_threats in self.threats:
                if _item_threats:
                    _items.append(_item_threats.to_dict())
            _dict['threats'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AdvisoryCSAFVulnerability from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "cve": obj.get("cve"),
            "cwe": AdvisoryCwe.from_dict(obj["cwe"]) if obj.get("cwe") is not None else None,
            "flags": [AdvisoryFlag.from_dict(_item) for _item in obj["flags"]] if obj.get("flags") is not None else None,
            "ids": [AdvisoryTrackingID.from_dict(_item) for _item in obj["ids"]] if obj.get("ids") is not None else None,
            "notes": [AdvisoryCSAFNote.from_dict(_item) for _item in obj["notes"]] if obj.get("notes") is not None else None,
            "product_status": obj.get("product_status"),
            "references": [AdvisoryCSAFReference.from_dict(_item) for _item in obj["references"]] if obj.get("references") is not None else None,
            "release_date": obj.get("release_date"),
            "remediations": [AdvisoryRemediationData.from_dict(_item) for _item in obj["remediations"]] if obj.get("remediations") is not None else None,
            "scores": [AdvisoryCSAFScore.from_dict(_item) for _item in obj["scores"]] if obj.get("scores") is not None else None,
            "threats": [AdvisoryThreatData.from_dict(_item) for _item in obj["threats"]] if obj.get("threats") is not None else None
        })
        return _obj


