# coding: utf-8

"""
    VulnCheck API

    Version 3 of the VulnCheck API

    The version of the OpenAPI document: 3.0
    Contact: support@vulncheck.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from vulncheck_sdk.models.advisory_enisa_id_product import AdvisoryEnisaIDProduct
from vulncheck_sdk.models.advisory_enisa_id_vendor import AdvisoryEnisaIDVendor
from typing import Optional, Set
from typing_extensions import Self

class AdvisoryEUVD(BaseModel):
    """
    AdvisoryEUVD
    """ # noqa: E501
    aliases: Optional[List[StrictStr]] = None
    assigner: Optional[StrictStr] = None
    base_score: Optional[Union[StrictFloat, StrictInt]] = None
    base_score_vector: Optional[StrictStr] = None
    base_score_version: Optional[StrictStr] = None
    cve: Optional[List[StrictStr]] = None
    date_added: Optional[StrictStr] = None
    date_updated: Optional[StrictStr] = None
    description: Optional[StrictStr] = None
    enisa_id_product: Optional[List[AdvisoryEnisaIDProduct]] = None
    enisa_id_vendor: Optional[List[AdvisoryEnisaIDVendor]] = None
    epss: Optional[Union[StrictFloat, StrictInt]] = None
    exploited: Optional[StrictBool] = Field(default=None, description="This field is exploited field from endpoint /api/vulnerabilities. apidocs : https://euvd.enisa.europa.eu/apidoc Note: There are records where exploited_since is populated with a valid date, but it still shows up under non_exploitable data set")
    exploited_since: Optional[StrictStr] = None
    id: Optional[StrictStr] = None
    references: Optional[List[StrictStr]] = None
    url: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["aliases", "assigner", "base_score", "base_score_vector", "base_score_version", "cve", "date_added", "date_updated", "description", "enisa_id_product", "enisa_id_vendor", "epss", "exploited", "exploited_since", "id", "references", "url"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AdvisoryEUVD from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in enisa_id_product (list)
        _items = []
        if self.enisa_id_product:
            for _item_enisa_id_product in self.enisa_id_product:
                if _item_enisa_id_product:
                    _items.append(_item_enisa_id_product.to_dict())
            _dict['enisa_id_product'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in enisa_id_vendor (list)
        _items = []
        if self.enisa_id_vendor:
            for _item_enisa_id_vendor in self.enisa_id_vendor:
                if _item_enisa_id_vendor:
                    _items.append(_item_enisa_id_vendor.to_dict())
            _dict['enisa_id_vendor'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AdvisoryEUVD from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "aliases": obj.get("aliases"),
            "assigner": obj.get("assigner"),
            "base_score": obj.get("base_score"),
            "base_score_vector": obj.get("base_score_vector"),
            "base_score_version": obj.get("base_score_version"),
            "cve": obj.get("cve"),
            "date_added": obj.get("date_added"),
            "date_updated": obj.get("date_updated"),
            "description": obj.get("description"),
            "enisa_id_product": [AdvisoryEnisaIDProduct.from_dict(_item) for _item in obj["enisa_id_product"]] if obj.get("enisa_id_product") is not None else None,
            "enisa_id_vendor": [AdvisoryEnisaIDVendor.from_dict(_item) for _item in obj["enisa_id_vendor"]] if obj.get("enisa_id_vendor") is not None else None,
            "epss": obj.get("epss"),
            "exploited": obj.get("exploited"),
            "exploited_since": obj.get("exploited_since"),
            "id": obj.get("id"),
            "references": obj.get("references"),
            "url": obj.get("url")
        })
        return _obj


