# coding: utf-8

"""
    VulnCheck API

    Version 3 of the VulnCheck API

    The version of the OpenAPI document: 3.0
    Contact: support@vulncheck.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from vulncheck_sdk.models.advisory_cwes import AdvisoryCwes
from vulncheck_sdk.models.advisory_gh_cvss import AdvisoryGHCvss
from vulncheck_sdk.models.advisory_gh_identifier import AdvisoryGHIdentifier
from vulncheck_sdk.models.advisory_gh_reference import AdvisoryGHReference
from vulncheck_sdk.models.advisory_gh_vulnerabilities import AdvisoryGHVulnerabilities
from typing import Optional, Set
from typing_extensions import Self

class AdvisoryGHAdvisoryJSONLean(BaseModel):
    """
    AdvisoryGHAdvisoryJSONLean
    """ # noqa: E501
    classification: Optional[StrictStr] = None
    cve: Optional[List[StrictStr]] = None
    cvss: Optional[AdvisoryGHCvss] = None
    cwes: Optional[AdvisoryCwes] = None
    database_id: Optional[StrictInt] = Field(default=None, alias="databaseId")
    date_added: Optional[StrictStr] = None
    description: Optional[StrictStr] = None
    ghsa_id: Optional[StrictStr] = Field(default=None, alias="ghsaId")
    id: Optional[StrictStr] = None
    identifiers: Optional[List[AdvisoryGHIdentifier]] = None
    notifications_permalink: Optional[StrictStr] = Field(default=None, alias="notificationsPermalink")
    origin: Optional[StrictStr] = None
    permalink: Optional[StrictStr] = None
    published_at: Optional[StrictStr] = Field(default=None, alias="publishedAt")
    references: Optional[List[AdvisoryGHReference]] = None
    severity: Optional[StrictStr] = None
    summary: Optional[StrictStr] = None
    updated_at: Optional[StrictStr] = None
    vulnerabilities: Optional[AdvisoryGHVulnerabilities] = None
    withdrawn_at: Optional[StrictStr] = Field(default=None, alias="withdrawnAt")
    __properties: ClassVar[List[str]] = ["classification", "cve", "cvss", "cwes", "databaseId", "date_added", "description", "ghsaId", "id", "identifiers", "notificationsPermalink", "origin", "permalink", "publishedAt", "references", "severity", "summary", "updated_at", "vulnerabilities", "withdrawnAt"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AdvisoryGHAdvisoryJSONLean from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of cvss
        if self.cvss:
            _dict['cvss'] = self.cvss.to_dict()
        # override the default output from pydantic by calling `to_dict()` of cwes
        if self.cwes:
            _dict['cwes'] = self.cwes.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in identifiers (list)
        _items = []
        if self.identifiers:
            for _item_identifiers in self.identifiers:
                if _item_identifiers:
                    _items.append(_item_identifiers.to_dict())
            _dict['identifiers'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in references (list)
        _items = []
        if self.references:
            for _item_references in self.references:
                if _item_references:
                    _items.append(_item_references.to_dict())
            _dict['references'] = _items
        # override the default output from pydantic by calling `to_dict()` of vulnerabilities
        if self.vulnerabilities:
            _dict['vulnerabilities'] = self.vulnerabilities.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AdvisoryGHAdvisoryJSONLean from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "classification": obj.get("classification"),
            "cve": obj.get("cve"),
            "cvss": AdvisoryGHCvss.from_dict(obj["cvss"]) if obj.get("cvss") is not None else None,
            "cwes": AdvisoryCwes.from_dict(obj["cwes"]) if obj.get("cwes") is not None else None,
            "databaseId": obj.get("databaseId"),
            "date_added": obj.get("date_added"),
            "description": obj.get("description"),
            "ghsaId": obj.get("ghsaId"),
            "id": obj.get("id"),
            "identifiers": [AdvisoryGHIdentifier.from_dict(_item) for _item in obj["identifiers"]] if obj.get("identifiers") is not None else None,
            "notificationsPermalink": obj.get("notificationsPermalink"),
            "origin": obj.get("origin"),
            "permalink": obj.get("permalink"),
            "publishedAt": obj.get("publishedAt"),
            "references": [AdvisoryGHReference.from_dict(_item) for _item in obj["references"]] if obj.get("references") is not None else None,
            "severity": obj.get("severity"),
            "summary": obj.get("summary"),
            "updated_at": obj.get("updated_at"),
            "vulnerabilities": AdvisoryGHVulnerabilities.from_dict(obj["vulnerabilities"]) if obj.get("vulnerabilities") is not None else None,
            "withdrawnAt": obj.get("withdrawnAt")
        })
        return _obj


