# coding: utf-8

"""
    VulnCheck API

    Version 3 of the VulnCheck API

    The version of the OpenAPI document: 3.0
    Contact: support@vulncheck.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict
from typing import Any, ClassVar, Dict, List, Optional
from vulncheck_sdk.models.advisory_ghsa_eco_system_specific import AdvisoryGHSAEcoSystemSpecific
from vulncheck_sdk.models.advisory_ghsa_package import AdvisoryGHSAPackage
from vulncheck_sdk.models.advisory_ghsa_range import AdvisoryGHSARange
from typing import Optional, Set
from typing_extensions import Self

class AdvisoryGHSAAffected(BaseModel):
    """
    AdvisoryGHSAAffected
    """ # noqa: E501
    ecosystem_specific: Optional[AdvisoryGHSAEcoSystemSpecific] = None
    package: Optional[AdvisoryGHSAPackage] = None
    ranges: Optional[List[AdvisoryGHSARange]] = None
    __properties: ClassVar[List[str]] = ["ecosystem_specific", "package", "ranges"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AdvisoryGHSAAffected from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of ecosystem_specific
        if self.ecosystem_specific:
            _dict['ecosystem_specific'] = self.ecosystem_specific.to_dict()
        # override the default output from pydantic by calling `to_dict()` of package
        if self.package:
            _dict['package'] = self.package.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in ranges (list)
        _items = []
        if self.ranges:
            for _item_ranges in self.ranges:
                if _item_ranges:
                    _items.append(_item_ranges.to_dict())
            _dict['ranges'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AdvisoryGHSAAffected from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "ecosystem_specific": AdvisoryGHSAEcoSystemSpecific.from_dict(obj["ecosystem_specific"]) if obj.get("ecosystem_specific") is not None else None,
            "package": AdvisoryGHSAPackage.from_dict(obj["package"]) if obj.get("package") is not None else None,
            "ranges": [AdvisoryGHSARange.from_dict(_item) for _item in obj["ranges"]] if obj.get("ranges") is not None else None
        })
        return _obj


