# coding: utf-8

"""
    VulnCheck API

    Version 3 of the VulnCheck API

    The version of the OpenAPI document: 3.0
    Contact: support@vulncheck.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from vulncheck_sdk.models.advisory_go_credits import AdvisoryGoCredits
from vulncheck_sdk.models.advisory_go_vuln_affected import AdvisoryGoVulnAffected
from vulncheck_sdk.models.advisory_go_vuln_reference import AdvisoryGoVulnReference
from typing import Optional, Set
from typing_extensions import Self

class AdvisoryGoVulnJSON(BaseModel):
    """
    AdvisoryGoVulnJSON
    """ # noqa: E501
    advisory_url: Optional[StrictStr] = None
    affected: Optional[List[AdvisoryGoVulnAffected]] = None
    aliases: Optional[List[StrictStr]] = None
    credits: Optional[List[AdvisoryGoCredits]] = None
    cve: Optional[List[StrictStr]] = None
    date_added: Optional[StrictStr] = None
    details: Optional[StrictStr] = None
    ghsa: Optional[List[StrictStr]] = None
    go_advisory_id: Optional[StrictStr] = None
    modified: Optional[StrictStr] = None
    published: Optional[StrictStr] = None
    references: Optional[List[AdvisoryGoVulnReference]] = None
    __properties: ClassVar[List[str]] = ["advisory_url", "affected", "aliases", "credits", "cve", "date_added", "details", "ghsa", "go_advisory_id", "modified", "published", "references"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AdvisoryGoVulnJSON from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in affected (list)
        _items = []
        if self.affected:
            for _item_affected in self.affected:
                if _item_affected:
                    _items.append(_item_affected.to_dict())
            _dict['affected'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in credits (list)
        _items = []
        if self.credits:
            for _item_credits in self.credits:
                if _item_credits:
                    _items.append(_item_credits.to_dict())
            _dict['credits'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in references (list)
        _items = []
        if self.references:
            for _item_references in self.references:
                if _item_references:
                    _items.append(_item_references.to_dict())
            _dict['references'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AdvisoryGoVulnJSON from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "advisory_url": obj.get("advisory_url"),
            "affected": [AdvisoryGoVulnAffected.from_dict(_item) for _item in obj["affected"]] if obj.get("affected") is not None else None,
            "aliases": obj.get("aliases"),
            "credits": [AdvisoryGoCredits.from_dict(_item) for _item in obj["credits"]] if obj.get("credits") is not None else None,
            "cve": obj.get("cve"),
            "date_added": obj.get("date_added"),
            "details": obj.get("details"),
            "ghsa": obj.get("ghsa"),
            "go_advisory_id": obj.get("go_advisory_id"),
            "modified": obj.get("modified"),
            "published": obj.get("published"),
            "references": [AdvisoryGoVulnReference.from_dict(_item) for _item in obj["references"]] if obj.get("references") is not None else None
        })
        return _obj


