# coding: utf-8

"""
    VulnCheck API

    Version 3 of the VulnCheck API

    The version of the OpenAPI document: 3.0
    Contact: support@vulncheck.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from vulncheck_sdk.models.advisory_affected_product import AdvisoryAffectedProduct
from typing import Optional, Set
from typing_extensions import Self

class AdvisoryLexmarkAdvisory(BaseModel):
    """
    AdvisoryLexmarkAdvisory
    """ # noqa: E501
    affected_products: Optional[List[AdvisoryAffectedProduct]] = Field(default=None, alias="affectedProducts")
    cve: Optional[List[StrictStr]] = None
    date_added: Optional[StrictStr] = None
    details: Optional[StrictStr] = None
    impact: Optional[StrictStr] = None
    last_update: Optional[StrictStr] = Field(default=None, alias="lastUpdate")
    link: Optional[StrictStr] = None
    public_release_date: Optional[StrictStr] = Field(default=None, alias="publicReleaseDate")
    references: Optional[List[StrictStr]] = None
    revision: Optional[StrictStr] = None
    summary: Optional[StrictStr] = None
    updated_at: Optional[StrictStr] = None
    workarounds: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["affectedProducts", "cve", "date_added", "details", "impact", "lastUpdate", "link", "publicReleaseDate", "references", "revision", "summary", "updated_at", "workarounds"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AdvisoryLexmarkAdvisory from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in affected_products (list)
        _items = []
        if self.affected_products:
            for _item_affected_products in self.affected_products:
                if _item_affected_products:
                    _items.append(_item_affected_products.to_dict())
            _dict['affectedProducts'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AdvisoryLexmarkAdvisory from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "affectedProducts": [AdvisoryAffectedProduct.from_dict(_item) for _item in obj["affectedProducts"]] if obj.get("affectedProducts") is not None else None,
            "cve": obj.get("cve"),
            "date_added": obj.get("date_added"),
            "details": obj.get("details"),
            "impact": obj.get("impact"),
            "lastUpdate": obj.get("lastUpdate"),
            "link": obj.get("link"),
            "publicReleaseDate": obj.get("publicReleaseDate"),
            "references": obj.get("references"),
            "revision": obj.get("revision"),
            "summary": obj.get("summary"),
            "updated_at": obj.get("updated_at"),
            "workarounds": obj.get("workarounds")
        })
        return _obj


