# coding: utf-8

"""
    VulnCheck API

    Version 3 of the VulnCheck API

    The version of the OpenAPI document: 3.0
    Contact: support@vulncheck.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class AdvisoryMCvssV31(BaseModel):
    """
    AdvisoryMCvssV31
    """ # noqa: E501
    attack_complexity: Optional[StrictStr] = Field(default=None, alias="attackComplexity")
    attack_vector: Optional[StrictStr] = Field(default=None, alias="attackVector")
    availability_impact: Optional[StrictStr] = Field(default=None, alias="availabilityImpact")
    base_score: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="baseScore")
    base_severity: Optional[StrictStr] = Field(default=None, alias="baseSeverity")
    confidentiality_impact: Optional[StrictStr] = Field(default=None, alias="confidentialityImpact")
    integrity_impact: Optional[StrictStr] = Field(default=None, alias="integrityImpact")
    privileges_required: Optional[StrictStr] = Field(default=None, alias="privilegesRequired")
    scope: Optional[StrictStr] = None
    user_interaction: Optional[StrictStr] = Field(default=None, alias="userInteraction")
    vector_string: Optional[StrictStr] = Field(default=None, alias="vectorString")
    version: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["attackComplexity", "attackVector", "availabilityImpact", "baseScore", "baseSeverity", "confidentialityImpact", "integrityImpact", "privilegesRequired", "scope", "userInteraction", "vectorString", "version"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AdvisoryMCvssV31 from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AdvisoryMCvssV31 from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "attackComplexity": obj.get("attackComplexity"),
            "attackVector": obj.get("attackVector"),
            "availabilityImpact": obj.get("availabilityImpact"),
            "baseScore": obj.get("baseScore"),
            "baseSeverity": obj.get("baseSeverity"),
            "confidentialityImpact": obj.get("confidentialityImpact"),
            "integrityImpact": obj.get("integrityImpact"),
            "privilegesRequired": obj.get("privilegesRequired"),
            "scope": obj.get("scope"),
            "userInteraction": obj.get("userInteraction"),
            "vectorString": obj.get("vectorString"),
            "version": obj.get("version")
        })
        return _obj


