# coding: utf-8

"""
    VulnCheck API

    Version 3 of the VulnCheck API

    The version of the OpenAPI document: 3.0
    Contact: support@vulncheck.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class AdvisoryMCvssV40(BaseModel):
    """
    AdvisoryMCvssV40
    """ # noqa: E501
    automatable: Optional[StrictStr] = Field(default=None, alias="Automatable")
    recovery: Optional[StrictStr] = Field(default=None, alias="Recovery")
    safety: Optional[StrictStr] = Field(default=None, alias="Safety")
    attack_complexity: Optional[StrictStr] = Field(default=None, alias="attackComplexity")
    attack_requirements: Optional[StrictStr] = Field(default=None, alias="attackRequirements")
    attack_vector: Optional[StrictStr] = Field(default=None, alias="attackVector")
    base_score: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="baseScore")
    base_severity: Optional[StrictStr] = Field(default=None, alias="baseSeverity")
    privileges_required: Optional[StrictStr] = Field(default=None, alias="privilegesRequired")
    provider_urgency: Optional[StrictStr] = Field(default=None, alias="providerUrgency")
    sub_availability_impact: Optional[StrictStr] = Field(default=None, alias="subAvailabilityImpact")
    sub_confidentiality_impact: Optional[StrictStr] = Field(default=None, alias="subConfidentialityImpact")
    sub_integrity_impact: Optional[StrictStr] = Field(default=None, alias="subIntegrityImpact")
    user_interaction: Optional[StrictStr] = Field(default=None, alias="userInteraction")
    value_density: Optional[StrictStr] = Field(default=None, alias="valueDensity")
    vector_string: Optional[StrictStr] = Field(default=None, alias="vectorString")
    version: Optional[StrictStr] = None
    vuln_availability_impact: Optional[StrictStr] = Field(default=None, alias="vulnAvailabilityImpact")
    vuln_confidentiality_impact: Optional[StrictStr] = Field(default=None, alias="vulnConfidentialityImpact")
    vuln_integrity_impact: Optional[StrictStr] = Field(default=None, alias="vulnIntegrityImpact")
    vulnerability_response_effort: Optional[StrictStr] = Field(default=None, alias="vulnerabilityResponseEffort")
    __properties: ClassVar[List[str]] = ["Automatable", "Recovery", "Safety", "attackComplexity", "attackRequirements", "attackVector", "baseScore", "baseSeverity", "privilegesRequired", "providerUrgency", "subAvailabilityImpact", "subConfidentialityImpact", "subIntegrityImpact", "userInteraction", "valueDensity", "vectorString", "version", "vulnAvailabilityImpact", "vulnConfidentialityImpact", "vulnIntegrityImpact", "vulnerabilityResponseEffort"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AdvisoryMCvssV40 from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AdvisoryMCvssV40 from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "Automatable": obj.get("Automatable"),
            "Recovery": obj.get("Recovery"),
            "Safety": obj.get("Safety"),
            "attackComplexity": obj.get("attackComplexity"),
            "attackRequirements": obj.get("attackRequirements"),
            "attackVector": obj.get("attackVector"),
            "baseScore": obj.get("baseScore"),
            "baseSeverity": obj.get("baseSeverity"),
            "privilegesRequired": obj.get("privilegesRequired"),
            "providerUrgency": obj.get("providerUrgency"),
            "subAvailabilityImpact": obj.get("subAvailabilityImpact"),
            "subConfidentialityImpact": obj.get("subConfidentialityImpact"),
            "subIntegrityImpact": obj.get("subIntegrityImpact"),
            "userInteraction": obj.get("userInteraction"),
            "valueDensity": obj.get("valueDensity"),
            "vectorString": obj.get("vectorString"),
            "version": obj.get("version"),
            "vulnAvailabilityImpact": obj.get("vulnAvailabilityImpact"),
            "vulnConfidentialityImpact": obj.get("vulnConfidentialityImpact"),
            "vulnIntegrityImpact": obj.get("vulnIntegrityImpact"),
            "vulnerabilityResponseEffort": obj.get("vulnerabilityResponseEffort")
        })
        return _obj


