# coding: utf-8

"""
    VulnCheck API

    Version 3 of the VulnCheck API

    The version of the OpenAPI document: 3.0
    Contact: support@vulncheck.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from vulncheck_sdk.models.advisory_affected_file import AdvisoryAffectedFile
from vulncheck_sdk.models.advisory_i_val import AdvisoryIVal
from typing import Optional, Set
from typing_extensions import Self

class AdvisoryMRemediation(BaseModel):
    """
    AdvisoryMRemediation
    """ # noqa: E501
    affected_files: Optional[List[AdvisoryAffectedFile]] = Field(default=None, alias="AffectedFiles")
    var_date: Optional[StrictStr] = Field(default=None, alias="Date")
    date_specified: Optional[StrictBool] = Field(default=None, alias="DateSpecified")
    description: Optional[AdvisoryIVal] = Field(default=None, alias="Description")
    fixed_build: Optional[StrictStr] = Field(default=None, alias="FixedBuild")
    product_id: Optional[List[StrictStr]] = Field(default=None, alias="ProductID")
    restart_required: Optional[AdvisoryIVal] = Field(default=None, alias="RestartRequired")
    sub_type: Optional[StrictStr] = Field(default=None, alias="SubType")
    type: Optional[StrictInt] = Field(default=None, description="diff", alias="Type")
    url: Optional[StrictStr] = Field(default=None, alias="Url")
    supercedence: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["AffectedFiles", "Date", "DateSpecified", "Description", "FixedBuild", "ProductID", "RestartRequired", "SubType", "Type", "Url", "supercedence"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AdvisoryMRemediation from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in affected_files (list)
        _items = []
        if self.affected_files:
            for _item_affected_files in self.affected_files:
                if _item_affected_files:
                    _items.append(_item_affected_files.to_dict())
            _dict['AffectedFiles'] = _items
        # override the default output from pydantic by calling `to_dict()` of description
        if self.description:
            _dict['Description'] = self.description.to_dict()
        # override the default output from pydantic by calling `to_dict()` of restart_required
        if self.restart_required:
            _dict['RestartRequired'] = self.restart_required.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AdvisoryMRemediation from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "AffectedFiles": [AdvisoryAffectedFile.from_dict(_item) for _item in obj["AffectedFiles"]] if obj.get("AffectedFiles") is not None else None,
            "Date": obj.get("Date"),
            "DateSpecified": obj.get("DateSpecified"),
            "Description": AdvisoryIVal.from_dict(obj["Description"]) if obj.get("Description") is not None else None,
            "FixedBuild": obj.get("FixedBuild"),
            "ProductID": obj.get("ProductID"),
            "RestartRequired": AdvisoryIVal.from_dict(obj["RestartRequired"]) if obj.get("RestartRequired") is not None else None,
            "SubType": obj.get("SubType"),
            "Type": obj.get("Type"),
            "Url": obj.get("Url"),
            "supercedence": obj.get("supercedence")
        })
        return _obj


