# coding: utf-8

"""
    VulnCheck API

    Version 3 of the VulnCheck API

    The version of the OpenAPI document: 3.0
    Contact: support@vulncheck.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from vulncheck_sdk.models.advisory_acknowledgement import AdvisoryAcknowledgement
from vulncheck_sdk.models.advisory_i_val import AdvisoryIVal
from vulncheck_sdk.models.advisory_m_product_status import AdvisoryMProductStatus
from vulncheck_sdk.models.advisory_m_remediation import AdvisoryMRemediation
from vulncheck_sdk.models.advisory_note import AdvisoryNote
from vulncheck_sdk.models.advisory_r_revision import AdvisoryRRevision
from vulncheck_sdk.models.advisory_r_score_set import AdvisoryRScoreSet
from vulncheck_sdk.models.advisory_r_threat import AdvisoryRThreat
from typing import Optional, Set
from typing_extensions import Self

class AdvisoryMVulnerability(BaseModel):
    """
    AdvisoryMVulnerability
    """ # noqa: E501
    product_statuses: Optional[List[AdvisoryMProductStatus]] = Field(default=None, alias="ProductStatuses")
    remediations: Optional[List[AdvisoryMRemediation]] = Field(default=None, alias="Remediations")
    threats: Optional[List[AdvisoryRThreat]] = Field(default=None, alias="Threats")
    acknowledgments: Optional[List[AdvisoryAcknowledgement]] = None
    cve: Optional[StrictStr] = None
    cvssscoresets: Optional[List[AdvisoryRScoreSet]] = None
    notes: Optional[List[AdvisoryNote]] = None
    ordinal: Optional[StrictStr] = None
    revisionhistory: Optional[List[AdvisoryRRevision]] = Field(default=None, description="diff in xml/json")
    title: Optional[AdvisoryIVal] = None
    __properties: ClassVar[List[str]] = ["ProductStatuses", "Remediations", "Threats", "acknowledgments", "cve", "cvssscoresets", "notes", "ordinal", "revisionhistory", "title"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AdvisoryMVulnerability from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in product_statuses (list)
        _items = []
        if self.product_statuses:
            for _item_product_statuses in self.product_statuses:
                if _item_product_statuses:
                    _items.append(_item_product_statuses.to_dict())
            _dict['ProductStatuses'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in remediations (list)
        _items = []
        if self.remediations:
            for _item_remediations in self.remediations:
                if _item_remediations:
                    _items.append(_item_remediations.to_dict())
            _dict['Remediations'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in threats (list)
        _items = []
        if self.threats:
            for _item_threats in self.threats:
                if _item_threats:
                    _items.append(_item_threats.to_dict())
            _dict['Threats'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in acknowledgments (list)
        _items = []
        if self.acknowledgments:
            for _item_acknowledgments in self.acknowledgments:
                if _item_acknowledgments:
                    _items.append(_item_acknowledgments.to_dict())
            _dict['acknowledgments'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in cvssscoresets (list)
        _items = []
        if self.cvssscoresets:
            for _item_cvssscoresets in self.cvssscoresets:
                if _item_cvssscoresets:
                    _items.append(_item_cvssscoresets.to_dict())
            _dict['cvssscoresets'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in notes (list)
        _items = []
        if self.notes:
            for _item_notes in self.notes:
                if _item_notes:
                    _items.append(_item_notes.to_dict())
            _dict['notes'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in revisionhistory (list)
        _items = []
        if self.revisionhistory:
            for _item_revisionhistory in self.revisionhistory:
                if _item_revisionhistory:
                    _items.append(_item_revisionhistory.to_dict())
            _dict['revisionhistory'] = _items
        # override the default output from pydantic by calling `to_dict()` of title
        if self.title:
            _dict['title'] = self.title.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AdvisoryMVulnerability from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "ProductStatuses": [AdvisoryMProductStatus.from_dict(_item) for _item in obj["ProductStatuses"]] if obj.get("ProductStatuses") is not None else None,
            "Remediations": [AdvisoryMRemediation.from_dict(_item) for _item in obj["Remediations"]] if obj.get("Remediations") is not None else None,
            "Threats": [AdvisoryRThreat.from_dict(_item) for _item in obj["Threats"]] if obj.get("Threats") is not None else None,
            "acknowledgments": [AdvisoryAcknowledgement.from_dict(_item) for _item in obj["acknowledgments"]] if obj.get("acknowledgments") is not None else None,
            "cve": obj.get("cve"),
            "cvssscoresets": [AdvisoryRScoreSet.from_dict(_item) for _item in obj["cvssscoresets"]] if obj.get("cvssscoresets") is not None else None,
            "notes": [AdvisoryNote.from_dict(_item) for _item in obj["notes"]] if obj.get("notes") is not None else None,
            "ordinal": obj.get("ordinal"),
            "revisionhistory": [AdvisoryRRevision.from_dict(_item) for _item in obj["revisionhistory"]] if obj.get("revisionhistory") is not None else None,
            "title": AdvisoryIVal.from_dict(obj["title"]) if obj.get("title") is not None else None
        })
        return _obj


