# coding: utf-8

"""
    VulnCheck API

    Version 3 of the VulnCheck API

    The version of the OpenAPI document: 3.0
    Contact: support@vulncheck.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from vulncheck_sdk.models.advisory_m_cvss_v20 import AdvisoryMCvssV20
from vulncheck_sdk.models.advisory_m_cvss_v30 import AdvisoryMCvssV30
from vulncheck_sdk.models.advisory_m_cvss_v31 import AdvisoryMCvssV31
from vulncheck_sdk.models.advisory_m_cvss_v40 import AdvisoryMCvssV40
from vulncheck_sdk.models.advisory_metrics_other import AdvisoryMetricsOther
from typing import Optional, Set
from typing_extensions import Self

class AdvisoryMetric(BaseModel):
    """
    AdvisoryMetric
    """ # noqa: E501
    cvss_v2_0: Optional[AdvisoryMCvssV20] = Field(default=None, alias="cvssV2_0")
    cvss_v3_0: Optional[AdvisoryMCvssV30] = Field(default=None, alias="cvssV3_0")
    cvss_v3_1: Optional[AdvisoryMCvssV31] = Field(default=None, alias="cvssV3_1")
    cvss_v4_0: Optional[AdvisoryMCvssV40] = Field(default=None, alias="cvssV4_0")
    format: Optional[StrictStr] = None
    other: Optional[AdvisoryMetricsOther] = None
    __properties: ClassVar[List[str]] = ["cvssV2_0", "cvssV3_0", "cvssV3_1", "cvssV4_0", "format", "other"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AdvisoryMetric from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of cvss_v2_0
        if self.cvss_v2_0:
            _dict['cvssV2_0'] = self.cvss_v2_0.to_dict()
        # override the default output from pydantic by calling `to_dict()` of cvss_v3_0
        if self.cvss_v3_0:
            _dict['cvssV3_0'] = self.cvss_v3_0.to_dict()
        # override the default output from pydantic by calling `to_dict()` of cvss_v3_1
        if self.cvss_v3_1:
            _dict['cvssV3_1'] = self.cvss_v3_1.to_dict()
        # override the default output from pydantic by calling `to_dict()` of cvss_v4_0
        if self.cvss_v4_0:
            _dict['cvssV4_0'] = self.cvss_v4_0.to_dict()
        # override the default output from pydantic by calling `to_dict()` of other
        if self.other:
            _dict['other'] = self.other.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AdvisoryMetric from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "cvssV2_0": AdvisoryMCvssV20.from_dict(obj["cvssV2_0"]) if obj.get("cvssV2_0") is not None else None,
            "cvssV3_0": AdvisoryMCvssV30.from_dict(obj["cvssV3_0"]) if obj.get("cvssV3_0") is not None else None,
            "cvssV3_1": AdvisoryMCvssV31.from_dict(obj["cvssV3_1"]) if obj.get("cvssV3_1") is not None else None,
            "cvssV4_0": AdvisoryMCvssV40.from_dict(obj["cvssV4_0"]) if obj.get("cvssV4_0") is not None else None,
            "format": obj.get("format"),
            "other": AdvisoryMetricsOther.from_dict(obj["other"]) if obj.get("other") is not None else None
        })
        return _obj


