# coding: utf-8

"""
    VulnCheck API

    Version 3 of the VulnCheck API

    The version of the OpenAPI document: 3.0
    Contact: support@vulncheck.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class AdvisoryMispMeta(BaseModel):
    """
    AdvisoryMispMeta
    """ # noqa: E501
    attribution_confidence: Optional[StrictStr] = Field(default=None, alias="attribution-confidence")
    cfr_suspected_state_sponsor: Optional[StrictStr] = Field(default=None, alias="cfr-suspected-state-sponsor")
    cfr_suspected_victims: Optional[List[StrictStr]] = Field(default=None, alias="cfr-suspected-victims")
    cfr_target_category: Optional[List[StrictStr]] = Field(default=None, alias="cfr-target-category")
    cfr_type_of_incident: Optional[List[StrictStr]] = Field(default=None, alias="cfr-type-of-incident")
    country: Optional[StrictStr] = None
    refs: Optional[List[StrictStr]] = None
    synonyms: Optional[List[StrictStr]] = None
    __properties: ClassVar[List[str]] = ["attribution-confidence", "cfr-suspected-state-sponsor", "cfr-suspected-victims", "cfr-target-category", "cfr-type-of-incident", "country", "refs", "synonyms"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AdvisoryMispMeta from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AdvisoryMispMeta from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "attribution-confidence": obj.get("attribution-confidence"),
            "cfr-suspected-state-sponsor": obj.get("cfr-suspected-state-sponsor"),
            "cfr-suspected-victims": obj.get("cfr-suspected-victims"),
            "cfr-target-category": obj.get("cfr-target-category"),
            "cfr-type-of-incident": obj.get("cfr-type-of-incident"),
            "country": obj.get("country"),
            "refs": obj.get("refs"),
            "synonyms": obj.get("synonyms")
        })
        return _obj


