# coding: utf-8

"""
    VulnCheck API

    Version 3 of the VulnCheck API

    The version of the OpenAPI document: 3.0
    Contact: support@vulncheck.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from vulncheck_sdk.models.advisory_mitre_attack_ref import AdvisoryMitreAttackRef
from vulncheck_sdk.models.advisory_nist_control import AdvisoryNISTControl
from typing import Optional, Set
from typing_extensions import Self

class AdvisoryMitreAttackTechWithRefs(BaseModel):
    """
    AdvisoryMitreAttackTechWithRefs
    """ # noqa: E501
    domain: Optional[StrictStr] = None
    id: Optional[StrictStr] = None
    name: Optional[StrictStr] = None
    nist_controls: Optional[List[AdvisoryNISTControl]] = None
    references: Optional[List[AdvisoryMitreAttackRef]] = None
    subtechnique: Optional[StrictBool] = None
    tactics: Optional[List[StrictStr]] = None
    url: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["domain", "id", "name", "nist_controls", "references", "subtechnique", "tactics", "url"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AdvisoryMitreAttackTechWithRefs from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in nist_controls (list)
        _items = []
        if self.nist_controls:
            for _item_nist_controls in self.nist_controls:
                if _item_nist_controls:
                    _items.append(_item_nist_controls.to_dict())
            _dict['nist_controls'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in references (list)
        _items = []
        if self.references:
            for _item_references in self.references:
                if _item_references:
                    _items.append(_item_references.to_dict())
            _dict['references'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AdvisoryMitreAttackTechWithRefs from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "domain": obj.get("domain"),
            "id": obj.get("id"),
            "name": obj.get("name"),
            "nist_controls": [AdvisoryNISTControl.from_dict(_item) for _item in obj["nist_controls"]] if obj.get("nist_controls") is not None else None,
            "references": [AdvisoryMitreAttackRef.from_dict(_item) for _item in obj["references"]] if obj.get("references") is not None else None,
            "subtechnique": obj.get("subtechnique"),
            "tactics": obj.get("tactics"),
            "url": obj.get("url")
        })
        return _obj


