# coding: utf-8

"""
    VulnCheck API

    Version 3 of the VulnCheck API

    The version of the OpenAPI document: 3.0
    Contact: support@vulncheck.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from vulncheck_sdk.models.advisory_mozilla_component import AdvisoryMozillaComponent
from typing import Optional, Set
from typing_extensions import Self

class AdvisoryMozillaAdvisory(BaseModel):
    """
    AdvisoryMozillaAdvisory
    """ # noqa: E501
    affected_components: Optional[List[AdvisoryMozillaComponent]] = None
    bugzilla: Optional[List[StrictStr]] = None
    cve: Optional[List[StrictStr]] = None
    date_added: Optional[StrictStr] = None
    description: Optional[StrictStr] = None
    fixed_in: Optional[List[StrictStr]] = None
    impact: Optional[StrictStr] = None
    products: Optional[List[StrictStr]] = None
    reporter: Optional[StrictStr] = None
    risk: Optional[StrictStr] = None
    title: Optional[StrictStr] = None
    url: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["affected_components", "bugzilla", "cve", "date_added", "description", "fixed_in", "impact", "products", "reporter", "risk", "title", "url"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AdvisoryMozillaAdvisory from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in affected_components (list)
        _items = []
        if self.affected_components:
            for _item_affected_components in self.affected_components:
                if _item_affected_components:
                    _items.append(_item_affected_components.to_dict())
            _dict['affected_components'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AdvisoryMozillaAdvisory from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "affected_components": [AdvisoryMozillaComponent.from_dict(_item) for _item in obj["affected_components"]] if obj.get("affected_components") is not None else None,
            "bugzilla": obj.get("bugzilla"),
            "cve": obj.get("cve"),
            "date_added": obj.get("date_added"),
            "description": obj.get("description"),
            "fixed_in": obj.get("fixed_in"),
            "impact": obj.get("impact"),
            "products": obj.get("products"),
            "reporter": obj.get("reporter"),
            "risk": obj.get("risk"),
            "title": obj.get("title"),
            "url": obj.get("url")
        })
        return _obj


