# coding: utf-8

"""
    VulnCheck API

    Version 3 of the VulnCheck API

    The version of the OpenAPI document: 3.0
    Contact: support@vulncheck.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from vulncheck_sdk.models.advisory_node_author import AdvisoryNodeAuthor
from typing import Optional, Set
from typing_extensions import Self

class AdvisoryNodeSecurity(BaseModel):
    """
    AdvisoryNodeSecurity
    """ # noqa: E501
    affected_environments: Optional[List[StrictStr]] = None
    author: Optional[AdvisoryNodeAuthor] = None
    coordinating_vendor: Optional[StrictStr] = None
    created_at: Optional[StrictStr] = None
    cve: Optional[List[StrictStr]] = None
    cvss_score: Optional[Union[StrictFloat, StrictInt]] = None
    cvss_vector: Optional[StrictStr] = None
    date_added: Optional[StrictStr] = None
    id: Optional[StrictInt] = None
    module_name: Optional[StrictStr] = None
    overview: Optional[StrictStr] = None
    patched_versions: Optional[StrictStr] = None
    publish_date: Optional[StrictStr] = None
    recommendation: Optional[StrictStr] = None
    references: Optional[List[StrictStr]] = None
    title: Optional[StrictStr] = None
    updated_at: Optional[StrictStr] = None
    url: Optional[StrictStr] = None
    vulnerable_versions: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["affected_environments", "author", "coordinating_vendor", "created_at", "cve", "cvss_score", "cvss_vector", "date_added", "id", "module_name", "overview", "patched_versions", "publish_date", "recommendation", "references", "title", "updated_at", "url", "vulnerable_versions"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AdvisoryNodeSecurity from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of author
        if self.author:
            _dict['author'] = self.author.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AdvisoryNodeSecurity from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "affected_environments": obj.get("affected_environments"),
            "author": AdvisoryNodeAuthor.from_dict(obj["author"]) if obj.get("author") is not None else None,
            "coordinating_vendor": obj.get("coordinating_vendor"),
            "created_at": obj.get("created_at"),
            "cve": obj.get("cve"),
            "cvss_score": obj.get("cvss_score"),
            "cvss_vector": obj.get("cvss_vector"),
            "date_added": obj.get("date_added"),
            "id": obj.get("id"),
            "module_name": obj.get("module_name"),
            "overview": obj.get("overview"),
            "patched_versions": obj.get("patched_versions"),
            "publish_date": obj.get("publish_date"),
            "recommendation": obj.get("recommendation"),
            "references": obj.get("references"),
            "title": obj.get("title"),
            "updated_at": obj.get("updated_at"),
            "url": obj.get("url"),
            "vulnerable_versions": obj.get("vulnerable_versions")
        })
        return _obj


