# coding: utf-8

"""
    VulnCheck API

    Version 3 of the VulnCheck API

    The version of the OpenAPI document: 3.0
    Contact: support@vulncheck.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class AdvisoryPaloAltoAdvisory(BaseModel):
    """
    AdvisoryPaloAltoAdvisory
    """ # noqa: E501
    affected: Optional[StrictStr] = None
    applicable_versions: Optional[StrictStr] = Field(default=None, alias="applicableVersions")
    attack_complexity: Optional[StrictStr] = Field(default=None, alias="attackComplexity")
    attack_requirements: Optional[StrictStr] = Field(default=None, alias="attackRequirements")
    attack_vector: Optional[StrictStr] = Field(default=None, alias="attackVector")
    availability_impact: Optional[StrictStr] = Field(default=None, alias="availabilityImpact")
    confidentiality_impact: Optional[StrictStr] = Field(default=None, alias="confidentialityImpact")
    cve: Optional[List[StrictStr]] = None
    cvssbase_score: Optional[StrictStr] = Field(default=None, alias="cvssbaseScore")
    date_published: Optional[StrictStr] = Field(default=None, alias="datePublished")
    date_updated: Optional[StrictStr] = Field(default=None, alias="dateUpdated")
    date_added: Optional[StrictStr] = None
    id: Optional[StrictStr] = None
    integrity_impact: Optional[StrictStr] = Field(default=None, alias="integrityImpact")
    privileges_required: Optional[StrictStr] = Field(default=None, alias="privilegesRequired")
    problem: Optional[StrictStr] = None
    product: Optional[StrictStr] = None
    scope: Optional[StrictStr] = None
    severity: Optional[StrictStr] = None
    solution: Optional[StrictStr] = None
    title: Optional[StrictStr] = None
    unaffected: Optional[StrictStr] = None
    url: Optional[StrictStr] = None
    user_interaction: Optional[StrictStr] = Field(default=None, alias="userInteraction")
    workaround: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["affected", "applicableVersions", "attackComplexity", "attackRequirements", "attackVector", "availabilityImpact", "confidentialityImpact", "cve", "cvssbaseScore", "datePublished", "dateUpdated", "date_added", "id", "integrityImpact", "privilegesRequired", "problem", "product", "scope", "severity", "solution", "title", "unaffected", "url", "userInteraction", "workaround"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AdvisoryPaloAltoAdvisory from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AdvisoryPaloAltoAdvisory from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "affected": obj.get("affected"),
            "applicableVersions": obj.get("applicableVersions"),
            "attackComplexity": obj.get("attackComplexity"),
            "attackRequirements": obj.get("attackRequirements"),
            "attackVector": obj.get("attackVector"),
            "availabilityImpact": obj.get("availabilityImpact"),
            "confidentialityImpact": obj.get("confidentialityImpact"),
            "cve": obj.get("cve"),
            "cvssbaseScore": obj.get("cvssbaseScore"),
            "datePublished": obj.get("datePublished"),
            "dateUpdated": obj.get("dateUpdated"),
            "date_added": obj.get("date_added"),
            "id": obj.get("id"),
            "integrityImpact": obj.get("integrityImpact"),
            "privilegesRequired": obj.get("privilegesRequired"),
            "problem": obj.get("problem"),
            "product": obj.get("product"),
            "scope": obj.get("scope"),
            "severity": obj.get("severity"),
            "solution": obj.get("solution"),
            "title": obj.get("title"),
            "unaffected": obj.get("unaffected"),
            "url": obj.get("url"),
            "userInteraction": obj.get("userInteraction"),
            "workaround": obj.get("workaround")
        })
        return _obj


