# coding: utf-8

"""
    VulnCheck API

    Version 3 of the VulnCheck API

    The version of the OpenAPI document: 3.0
    Contact: support@vulncheck.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from vulncheck_sdk.models.advisory_capec import AdvisoryCapec
from vulncheck_sdk.models.advisory_cve_reference import AdvisoryCVEReference
from vulncheck_sdk.models.advisory_cwe_data import AdvisoryCweData
from vulncheck_sdk.models.advisory_mitre_attack_tech_with_refs import AdvisoryMitreAttackTechWithRefs
from vulncheck_sdk.models.advisory_tool import AdvisoryTool
from typing import Optional, Set
from typing_extensions import Self

class AdvisoryRansomwareExploit(BaseModel):
    """
    AdvisoryRansomwareExploit
    """ # noqa: E501
    associated_capecs: Optional[List[AdvisoryCapec]] = None
    associated_cwes: Optional[List[AdvisoryCweData]] = None
    associated_mitre_attack_techniques: Optional[List[AdvisoryMitreAttackTechWithRefs]] = None
    cve: Optional[List[StrictStr]] = None
    cve_references: Optional[List[AdvisoryCVEReference]] = None
    date_added: Optional[StrictStr] = None
    malpedia_url: Optional[StrictStr] = None
    ransomware_family: Optional[StrictStr] = None
    tools: Optional[List[AdvisoryTool]] = None
    __properties: ClassVar[List[str]] = ["associated_capecs", "associated_cwes", "associated_mitre_attack_techniques", "cve", "cve_references", "date_added", "malpedia_url", "ransomware_family", "tools"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AdvisoryRansomwareExploit from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in associated_capecs (list)
        _items = []
        if self.associated_capecs:
            for _item_associated_capecs in self.associated_capecs:
                if _item_associated_capecs:
                    _items.append(_item_associated_capecs.to_dict())
            _dict['associated_capecs'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in associated_cwes (list)
        _items = []
        if self.associated_cwes:
            for _item_associated_cwes in self.associated_cwes:
                if _item_associated_cwes:
                    _items.append(_item_associated_cwes.to_dict())
            _dict['associated_cwes'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in associated_mitre_attack_techniques (list)
        _items = []
        if self.associated_mitre_attack_techniques:
            for _item_associated_mitre_attack_techniques in self.associated_mitre_attack_techniques:
                if _item_associated_mitre_attack_techniques:
                    _items.append(_item_associated_mitre_attack_techniques.to_dict())
            _dict['associated_mitre_attack_techniques'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in cve_references (list)
        _items = []
        if self.cve_references:
            for _item_cve_references in self.cve_references:
                if _item_cve_references:
                    _items.append(_item_cve_references.to_dict())
            _dict['cve_references'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in tools (list)
        _items = []
        if self.tools:
            for _item_tools in self.tools:
                if _item_tools:
                    _items.append(_item_tools.to_dict())
            _dict['tools'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AdvisoryRansomwareExploit from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "associated_capecs": [AdvisoryCapec.from_dict(_item) for _item in obj["associated_capecs"]] if obj.get("associated_capecs") is not None else None,
            "associated_cwes": [AdvisoryCweData.from_dict(_item) for _item in obj["associated_cwes"]] if obj.get("associated_cwes") is not None else None,
            "associated_mitre_attack_techniques": [AdvisoryMitreAttackTechWithRefs.from_dict(_item) for _item in obj["associated_mitre_attack_techniques"]] if obj.get("associated_mitre_attack_techniques") is not None else None,
            "cve": obj.get("cve"),
            "cve_references": [AdvisoryCVEReference.from_dict(_item) for _item in obj["cve_references"]] if obj.get("cve_references") is not None else None,
            "date_added": obj.get("date_added"),
            "malpedia_url": obj.get("malpedia_url"),
            "ransomware_family": obj.get("ransomware_family"),
            "tools": [AdvisoryTool.from_dict(_item) for _item in obj["tools"]] if obj.get("tools") is not None else None
        })
        return _obj


