# coding: utf-8

"""
    VulnCheck API

    Version 3 of the VulnCheck API

    The version of the OpenAPI document: 3.0
    Contact: support@vulncheck.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from vulncheck_sdk.models.advisory_rustsec_affected import AdvisoryRustsecAffected
from vulncheck_sdk.models.advisory_rustsec_front_matter_advisory import AdvisoryRustsecFrontMatterAdvisory
from vulncheck_sdk.models.advisory_rustsec_front_matter_versions import AdvisoryRustsecFrontMatterVersions
from typing import Optional, Set
from typing_extensions import Self

class AdvisoryRustsecAdvisory(BaseModel):
    """
    AdvisoryRustsecAdvisory
    """ # noqa: E501
    advisory: Optional[AdvisoryRustsecFrontMatterAdvisory] = None
    affected: Optional[AdvisoryRustsecAffected] = None
    cve: Optional[List[StrictStr]] = None
    date_added: Optional[StrictStr] = None
    description: Optional[StrictStr] = None
    versions: Optional[AdvisoryRustsecFrontMatterVersions] = None
    __properties: ClassVar[List[str]] = ["advisory", "affected", "cve", "date_added", "description", "versions"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AdvisoryRustsecAdvisory from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of advisory
        if self.advisory:
            _dict['advisory'] = self.advisory.to_dict()
        # override the default output from pydantic by calling `to_dict()` of affected
        if self.affected:
            _dict['affected'] = self.affected.to_dict()
        # override the default output from pydantic by calling `to_dict()` of versions
        if self.versions:
            _dict['versions'] = self.versions.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AdvisoryRustsecAdvisory from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "advisory": AdvisoryRustsecFrontMatterAdvisory.from_dict(obj["advisory"]) if obj.get("advisory") is not None else None,
            "affected": AdvisoryRustsecAffected.from_dict(obj["affected"]) if obj.get("affected") is not None else None,
            "cve": obj.get("cve"),
            "date_added": obj.get("date_added"),
            "description": obj.get("description"),
            "versions": AdvisoryRustsecFrontMatterVersions.from_dict(obj["versions"]) if obj.get("versions") is not None else None
        })
        return _obj


