# coding: utf-8

"""
    VulnCheck API

    Version 3 of the VulnCheck API

    The version of the OpenAPI document: 3.0
    Contact: support@vulncheck.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictBool, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class AdvisorySonicWallAdvisory(BaseModel):
    """
    AdvisorySonicWallAdvisory
    """ # noqa: E501
    advisory_id: Optional[StrictStr] = None
    affected_products: Optional[List[StrictStr]] = None
    cve: Optional[List[StrictStr]] = None
    cvss: Optional[StrictStr] = None
    cvss_vector: Optional[StrictStr] = None
    cvss_version: Optional[Union[StrictFloat, StrictInt]] = None
    cwe: Optional[StrictStr] = None
    date_added: Optional[StrictStr] = None
    impact: Optional[StrictStr] = None
    is_workaround_available: Optional[StrictBool] = None
    last_updated_when: Optional[StrictStr] = None
    published_when: Optional[StrictStr] = None
    summary: Optional[StrictStr] = None
    title: Optional[StrictStr] = None
    url: Optional[StrictStr] = None
    vuln_status: Optional[StrictStr] = None
    vulnerable_products_list: Optional[List[StrictStr]] = None
    __properties: ClassVar[List[str]] = ["advisory_id", "affected_products", "cve", "cvss", "cvss_vector", "cvss_version", "cwe", "date_added", "impact", "is_workaround_available", "last_updated_when", "published_when", "summary", "title", "url", "vuln_status", "vulnerable_products_list"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AdvisorySonicWallAdvisory from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AdvisorySonicWallAdvisory from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "advisory_id": obj.get("advisory_id"),
            "affected_products": obj.get("affected_products"),
            "cve": obj.get("cve"),
            "cvss": obj.get("cvss"),
            "cvss_vector": obj.get("cvss_vector"),
            "cvss_version": obj.get("cvss_version"),
            "cwe": obj.get("cwe"),
            "date_added": obj.get("date_added"),
            "impact": obj.get("impact"),
            "is_workaround_available": obj.get("is_workaround_available"),
            "last_updated_when": obj.get("last_updated_when"),
            "published_when": obj.get("published_when"),
            "summary": obj.get("summary"),
            "title": obj.get("title"),
            "url": obj.get("url"),
            "vuln_status": obj.get("vuln_status"),
            "vulnerable_products_list": obj.get("vulnerable_products_list")
        })
        return _obj


