# coding: utf-8

"""
    VulnCheck API

    Version 3 of the VulnCheck API

    The version of the OpenAPI document: 3.0
    Contact: support@vulncheck.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from vulncheck_sdk.models.advisory_cvrf_reference import AdvisoryCVRFReference
from vulncheck_sdk.models.advisory_score_set import AdvisoryScoreSet
from vulncheck_sdk.models.advisory_status import AdvisoryStatus
from vulncheck_sdk.models.advisory_threat import AdvisoryThreat
from vulncheck_sdk.models.advisory_vuln_check_package import AdvisoryVulnCheckPackage
from typing import Optional, Set
from typing_extensions import Self

class AdvisoryVulnerability(BaseModel):
    """
    AdvisoryVulnerability
    """ # noqa: E501
    cve: Optional[StrictStr] = None
    cvssscore_sets: Optional[AdvisoryScoreSet] = Field(default=None, alias="cvssscoreSets")
    description: Optional[StrictStr] = None
    packages: Optional[List[AdvisoryVulnCheckPackage]] = Field(default=None, description="vulncheck addition")
    product_statuses: Optional[List[AdvisoryStatus]] = Field(default=None, alias="productStatuses")
    references: Optional[List[AdvisoryCVRFReference]] = None
    threats: Optional[List[AdvisoryThreat]] = None
    __properties: ClassVar[List[str]] = ["cve", "cvssscoreSets", "description", "packages", "productStatuses", "references", "threats"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AdvisoryVulnerability from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of cvssscore_sets
        if self.cvssscore_sets:
            _dict['cvssscoreSets'] = self.cvssscore_sets.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in packages (list)
        _items = []
        if self.packages:
            for _item_packages in self.packages:
                if _item_packages:
                    _items.append(_item_packages.to_dict())
            _dict['packages'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in product_statuses (list)
        _items = []
        if self.product_statuses:
            for _item_product_statuses in self.product_statuses:
                if _item_product_statuses:
                    _items.append(_item_product_statuses.to_dict())
            _dict['productStatuses'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in references (list)
        _items = []
        if self.references:
            for _item_references in self.references:
                if _item_references:
                    _items.append(_item_references.to_dict())
            _dict['references'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in threats (list)
        _items = []
        if self.threats:
            for _item_threats in self.threats:
                if _item_threats:
                    _items.append(_item_threats.to_dict())
            _dict['threats'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AdvisoryVulnerability from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "cve": obj.get("cve"),
            "cvssscoreSets": AdvisoryScoreSet.from_dict(obj["cvssscoreSets"]) if obj.get("cvssscoreSets") is not None else None,
            "description": obj.get("description"),
            "packages": [AdvisoryVulnCheckPackage.from_dict(_item) for _item in obj["packages"]] if obj.get("packages") is not None else None,
            "productStatuses": [AdvisoryStatus.from_dict(_item) for _item in obj["productStatuses"]] if obj.get("productStatuses") is not None else None,
            "references": [AdvisoryCVRFReference.from_dict(_item) for _item in obj["references"]] if obj.get("references") is not None else None,
            "threats": [AdvisoryThreat.from_dict(_item) for _item in obj["threats"]] if obj.get("threats") is not None else None
        })
        return _obj


