# coding: utf-8

"""
    VulnCheck API

    Version 3 of the VulnCheck API

    The version of the OpenAPI document: 3.0
    Contact: support@vulncheck.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from vulncheck_sdk.models.api_cve_data_meta import ApiCVEDataMeta
from vulncheck_sdk.models.api_description import ApiDescription
from vulncheck_sdk.models.api_problem_type import ApiProblemType
from vulncheck_sdk.models.api_references import ApiReferences
from typing import Optional, Set
from typing_extensions import Self

class ApiCVE(BaseModel):
    """
    ApiCVE
    """ # noqa: E501
    cve_data_meta: Optional[ApiCVEDataMeta] = Field(default=None, alias="CVE_data_meta")
    data_format: Optional[StrictStr] = None
    data_type: Optional[StrictStr] = None
    data_version: Optional[StrictStr] = None
    description: Optional[ApiDescription] = None
    problemtype: Optional[ApiProblemType] = None
    references: Optional[ApiReferences] = None
    __properties: ClassVar[List[str]] = ["CVE_data_meta", "data_format", "data_type", "data_version", "description", "problemtype", "references"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ApiCVE from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of cve_data_meta
        if self.cve_data_meta:
            _dict['CVE_data_meta'] = self.cve_data_meta.to_dict()
        # override the default output from pydantic by calling `to_dict()` of description
        if self.description:
            _dict['description'] = self.description.to_dict()
        # override the default output from pydantic by calling `to_dict()` of problemtype
        if self.problemtype:
            _dict['problemtype'] = self.problemtype.to_dict()
        # override the default output from pydantic by calling `to_dict()` of references
        if self.references:
            _dict['references'] = self.references.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ApiCVE from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "CVE_data_meta": ApiCVEDataMeta.from_dict(obj["CVE_data_meta"]) if obj.get("CVE_data_meta") is not None else None,
            "data_format": obj.get("data_format"),
            "data_type": obj.get("data_type"),
            "data_version": obj.get("data_version"),
            "description": ApiDescription.from_dict(obj["description"]) if obj.get("description") is not None else None,
            "problemtype": ApiProblemType.from_dict(obj["problemtype"]) if obj.get("problemtype") is not None else None,
            "references": ApiReferences.from_dict(obj["references"]) if obj.get("references") is not None else None
        })
        return _obj


