# coding: utf-8

"""
    VulnCheck API

    Version 3 of the VulnCheck API

    The version of the OpenAPI document: 3.0
    Contact: support@vulncheck.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from vulncheck_sdk.models.api_configurations import ApiConfigurations
from vulncheck_sdk.models.api_cve_extended import ApiCVEExtended
from vulncheck_sdk.models.api_impact_extended import ApiImpactExtended
from vulncheck_sdk.models.api_mitre_attack_tech import ApiMitreAttackTech
from vulncheck_sdk.models.api_related_attack_pattern import ApiRelatedAttackPattern
from typing import Optional, Set
from typing_extensions import Self

class ApiCveItemsExtended(BaseModel):
    """
    ApiCveItemsExtended
    """ # noqa: E501
    timestamp: Optional[StrictStr] = Field(default=None, alias="_timestamp")
    configurations: Optional[ApiConfigurations] = None
    cve: Optional[ApiCVEExtended] = None
    date_added: Optional[StrictStr] = None
    document_generation_date: Optional[StrictStr] = Field(default=None, description="the deep tag instructs deep.Equal to ignore this field (used during OpenSearch loading)", alias="documentGenerationDate")
    impact: Optional[ApiImpactExtended] = None
    last_modified_date: Optional[StrictStr] = Field(default=None, alias="lastModifiedDate")
    mitre_attack_techniques: Optional[List[ApiMitreAttackTech]] = None
    published_date: Optional[StrictStr] = Field(default=None, alias="publishedDate")
    related_attack_patterns: Optional[List[ApiRelatedAttackPattern]] = None
    vc_configurations: Optional[ApiConfigurations] = Field(default=None, alias="vcConfigurations")
    vc_vulnerable_cpes: Optional[List[StrictStr]] = Field(default=None, alias="vcVulnerableCPEs")
    vulnerable_cpes: Optional[List[StrictStr]] = None
    __properties: ClassVar[List[str]] = ["_timestamp", "configurations", "cve", "date_added", "documentGenerationDate", "impact", "lastModifiedDate", "mitre_attack_techniques", "publishedDate", "related_attack_patterns", "vcConfigurations", "vcVulnerableCPEs", "vulnerable_cpes"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ApiCveItemsExtended from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of configurations
        if self.configurations:
            _dict['configurations'] = self.configurations.to_dict()
        # override the default output from pydantic by calling `to_dict()` of cve
        if self.cve:
            _dict['cve'] = self.cve.to_dict()
        # override the default output from pydantic by calling `to_dict()` of impact
        if self.impact:
            _dict['impact'] = self.impact.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in mitre_attack_techniques (list)
        _items = []
        if self.mitre_attack_techniques:
            for _item_mitre_attack_techniques in self.mitre_attack_techniques:
                if _item_mitre_attack_techniques:
                    _items.append(_item_mitre_attack_techniques.to_dict())
            _dict['mitre_attack_techniques'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in related_attack_patterns (list)
        _items = []
        if self.related_attack_patterns:
            for _item_related_attack_patterns in self.related_attack_patterns:
                if _item_related_attack_patterns:
                    _items.append(_item_related_attack_patterns.to_dict())
            _dict['related_attack_patterns'] = _items
        # override the default output from pydantic by calling `to_dict()` of vc_configurations
        if self.vc_configurations:
            _dict['vcConfigurations'] = self.vc_configurations.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ApiCveItemsExtended from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "_timestamp": obj.get("_timestamp"),
            "configurations": ApiConfigurations.from_dict(obj["configurations"]) if obj.get("configurations") is not None else None,
            "cve": ApiCVEExtended.from_dict(obj["cve"]) if obj.get("cve") is not None else None,
            "date_added": obj.get("date_added"),
            "documentGenerationDate": obj.get("documentGenerationDate"),
            "impact": ApiImpactExtended.from_dict(obj["impact"]) if obj.get("impact") is not None else None,
            "lastModifiedDate": obj.get("lastModifiedDate"),
            "mitre_attack_techniques": [ApiMitreAttackTech.from_dict(_item) for _item in obj["mitre_attack_techniques"]] if obj.get("mitre_attack_techniques") is not None else None,
            "publishedDate": obj.get("publishedDate"),
            "related_attack_patterns": [ApiRelatedAttackPattern.from_dict(_item) for _item in obj["related_attack_patterns"]] if obj.get("related_attack_patterns") is not None else None,
            "vcConfigurations": ApiConfigurations.from_dict(obj["vcConfigurations"]) if obj.get("vcConfigurations") is not None else None,
            "vcVulnerableCPEs": obj.get("vcVulnerableCPEs"),
            "vulnerable_cpes": obj.get("vulnerable_cpes")
        })
        return _obj


