# coding: utf-8

"""
    VulnCheck API

    Version 3 of the VulnCheck API

    The version of the OpenAPI document: 3.0
    Contact: support@vulncheck.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class ApiExploitsV3Timeline(BaseModel):
    """
    ApiExploitsV3Timeline
    """ # noqa: E501
    cisa_kev_date_added: Optional[StrictStr] = None
    cisa_kev_date_due: Optional[StrictStr] = None
    first_exploit_published: Optional[StrictStr] = None
    first_exploit_published_weaponized_or_higher: Optional[StrictStr] = None
    first_reported_botnet: Optional[StrictStr] = None
    first_reported_ransomware: Optional[StrictStr] = None
    first_reported_threat_actor: Optional[StrictStr] = None
    most_recent_exploit_published: Optional[StrictStr] = None
    most_recent_reported_botnet: Optional[StrictStr] = None
    most_recent_reported_ransomware: Optional[StrictStr] = None
    most_recent_reported_threat_actor: Optional[StrictStr] = None
    nvd_last_modified: Optional[StrictStr] = Field(default=None, description="it's often the case the nvd record was updated, but in a way that is irrelevant to the contents of a vc exploits record.")
    nvd_published: Optional[StrictStr] = None
    vulncheck_kev_date_added: Optional[StrictStr] = None
    vulncheck_kev_date_due: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["cisa_kev_date_added", "cisa_kev_date_due", "first_exploit_published", "first_exploit_published_weaponized_or_higher", "first_reported_botnet", "first_reported_ransomware", "first_reported_threat_actor", "most_recent_exploit_published", "most_recent_reported_botnet", "most_recent_reported_ransomware", "most_recent_reported_threat_actor", "nvd_last_modified", "nvd_published", "vulncheck_kev_date_added", "vulncheck_kev_date_due"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ApiExploitsV3Timeline from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ApiExploitsV3Timeline from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "cisa_kev_date_added": obj.get("cisa_kev_date_added"),
            "cisa_kev_date_due": obj.get("cisa_kev_date_due"),
            "first_exploit_published": obj.get("first_exploit_published"),
            "first_exploit_published_weaponized_or_higher": obj.get("first_exploit_published_weaponized_or_higher"),
            "first_reported_botnet": obj.get("first_reported_botnet"),
            "first_reported_ransomware": obj.get("first_reported_ransomware"),
            "first_reported_threat_actor": obj.get("first_reported_threat_actor"),
            "most_recent_exploit_published": obj.get("most_recent_exploit_published"),
            "most_recent_reported_botnet": obj.get("most_recent_reported_botnet"),
            "most_recent_reported_ransomware": obj.get("most_recent_reported_ransomware"),
            "most_recent_reported_threat_actor": obj.get("most_recent_reported_threat_actor"),
            "nvd_last_modified": obj.get("nvd_last_modified"),
            "nvd_published": obj.get("nvd_published"),
            "vulncheck_kev_date_added": obj.get("vulncheck_kev_date_added"),
            "vulncheck_kev_date_due": obj.get("vulncheck_kev_date_due")
        })
        return _obj


