# coding: utf-8

"""
    VulnCheck API

    Version 3 of the VulnCheck API

    The version of the OpenAPI document: 3.0
    Contact: support@vulncheck.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from vulncheck_sdk.models.api_nvd20_cvss_metric_v2 import ApiNVD20CvssMetricV2
from vulncheck_sdk.models.api_nvd20_cvss_metric_v3 import ApiNVD20CvssMetricV3
from vulncheck_sdk.models.api_nvd20_cvss_metric_v40 import ApiNVD20CvssMetricV40
from typing import Optional, Set
from typing_extensions import Self

class ApiNVD20Metric(BaseModel):
    """
    ApiNVD20Metric
    """ # noqa: E501
    cvss_metric_v2: Optional[List[ApiNVD20CvssMetricV2]] = Field(default=None, alias="cvssMetricV2")
    cvss_metric_v30: Optional[List[ApiNVD20CvssMetricV3]] = Field(default=None, alias="cvssMetricV30")
    cvss_metric_v31: Optional[List[ApiNVD20CvssMetricV3]] = Field(default=None, alias="cvssMetricV31")
    cvss_metric_v40: Optional[List[ApiNVD20CvssMetricV40]] = Field(default=None, alias="cvssMetricV40")
    __properties: ClassVar[List[str]] = ["cvssMetricV2", "cvssMetricV30", "cvssMetricV31", "cvssMetricV40"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ApiNVD20Metric from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in cvss_metric_v2 (list)
        _items = []
        if self.cvss_metric_v2:
            for _item_cvss_metric_v2 in self.cvss_metric_v2:
                if _item_cvss_metric_v2:
                    _items.append(_item_cvss_metric_v2.to_dict())
            _dict['cvssMetricV2'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in cvss_metric_v30 (list)
        _items = []
        if self.cvss_metric_v30:
            for _item_cvss_metric_v30 in self.cvss_metric_v30:
                if _item_cvss_metric_v30:
                    _items.append(_item_cvss_metric_v30.to_dict())
            _dict['cvssMetricV30'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in cvss_metric_v31 (list)
        _items = []
        if self.cvss_metric_v31:
            for _item_cvss_metric_v31 in self.cvss_metric_v31:
                if _item_cvss_metric_v31:
                    _items.append(_item_cvss_metric_v31.to_dict())
            _dict['cvssMetricV31'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in cvss_metric_v40 (list)
        _items = []
        if self.cvss_metric_v40:
            for _item_cvss_metric_v40 in self.cvss_metric_v40:
                if _item_cvss_metric_v40:
                    _items.append(_item_cvss_metric_v40.to_dict())
            _dict['cvssMetricV40'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ApiNVD20Metric from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "cvssMetricV2": [ApiNVD20CvssMetricV2.from_dict(_item) for _item in obj["cvssMetricV2"]] if obj.get("cvssMetricV2") is not None else None,
            "cvssMetricV30": [ApiNVD20CvssMetricV3.from_dict(_item) for _item in obj["cvssMetricV30"]] if obj.get("cvssMetricV30") is not None else None,
            "cvssMetricV31": [ApiNVD20CvssMetricV3.from_dict(_item) for _item in obj["cvssMetricV31"]] if obj.get("cvssMetricV31") is not None else None,
            "cvssMetricV40": [ApiNVD20CvssMetricV40.from_dict(_item) for _item in obj["cvssMetricV40"]] if obj.get("cvssMetricV40") is not None else None
        })
        return _obj


