# coding: utf-8

"""
    VulnCheck API

    Version 3 of the VulnCheck API

    The version of the OpenAPI document: 3.0
    Contact: support@vulncheck.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from vulncheck_sdk.models.api_nvd20_threat_associated_base_metric import ApiNVD20ThreatAssociatedBaseMetric
from typing import Optional, Set
from typing_extensions import Self

class ApiNVD20ThreatCVSSV40(BaseModel):
    """
    ApiNVD20ThreatCVSSV40
    """ # noqa: E501
    associated_base_metric_v40: Optional[ApiNVD20ThreatAssociatedBaseMetric] = Field(default=None, alias="associatedBaseMetricV40")
    base_threat_score: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="baseThreatScore")
    base_threat_severity: Optional[StrictStr] = Field(default=None, alias="baseThreatSeverity")
    exploit_maturity: Optional[StrictStr] = Field(default=None, alias="exploitMaturity")
    __properties: ClassVar[List[str]] = ["associatedBaseMetricV40", "baseThreatScore", "baseThreatSeverity", "exploitMaturity"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ApiNVD20ThreatCVSSV40 from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of associated_base_metric_v40
        if self.associated_base_metric_v40:
            _dict['associatedBaseMetricV40'] = self.associated_base_metric_v40.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ApiNVD20ThreatCVSSV40 from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "associatedBaseMetricV40": ApiNVD20ThreatAssociatedBaseMetric.from_dict(obj["associatedBaseMetricV40"]) if obj.get("associatedBaseMetricV40") is not None else None,
            "baseThreatScore": obj.get("baseThreatScore"),
            "baseThreatSeverity": obj.get("baseThreatSeverity"),
            "exploitMaturity": obj.get("exploitMaturity")
        })
        return _obj


