# coding: utf-8

"""
    VulnCheck API

    Version 3 of the VulnCheck API

    The version of the OpenAPI document: 3.0
    Contact: support@vulncheck.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from vulncheck_sdk.models.api_client_fingerprints import ApiClientFingerprints
from vulncheck_sdk.models.api_http_details import ApiHTTPDetails
from typing import Optional, Set
from typing_extensions import Self

class ApiVulnCheckCanary(BaseModel):
    """
    ApiVulnCheckCanary
    """ # noqa: E501
    category: Optional[StrictStr] = None
    client_fingerprints: Optional[ApiClientFingerprints] = None
    cve: Optional[StrictStr] = None
    dst_country: Optional[StrictStr] = None
    http: Optional[ApiHTTPDetails] = None
    payload: Optional[StrictStr] = None
    severity: Optional[StrictInt] = None
    signature: Optional[StrictStr] = None
    signature_id: Optional[StrictInt] = None
    src_country: Optional[StrictStr] = None
    src_ip: Optional[StrictStr] = None
    src_port: Optional[StrictInt] = None
    timestamp: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["category", "client_fingerprints", "cve", "dst_country", "http", "payload", "severity", "signature", "signature_id", "src_country", "src_ip", "src_port", "timestamp"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ApiVulnCheckCanary from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of client_fingerprints
        if self.client_fingerprints:
            _dict['client_fingerprints'] = self.client_fingerprints.to_dict()
        # override the default output from pydantic by calling `to_dict()` of http
        if self.http:
            _dict['http'] = self.http.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ApiVulnCheckCanary from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "category": obj.get("category"),
            "client_fingerprints": ApiClientFingerprints.from_dict(obj["client_fingerprints"]) if obj.get("client_fingerprints") is not None else None,
            "cve": obj.get("cve"),
            "dst_country": obj.get("dst_country"),
            "http": ApiHTTPDetails.from_dict(obj["http"]) if obj.get("http") is not None else None,
            "payload": obj.get("payload"),
            "severity": obj.get("severity"),
            "signature": obj.get("signature"),
            "signature_id": obj.get("signature_id"),
            "src_country": obj.get("src_country"),
            "src_ip": obj.get("src_ip"),
            "src_port": obj.get("src_port"),
            "timestamp": obj.get("timestamp")
        })
        return _obj


