"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CodeArtifact = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_codeartifact_1 = require("aws-cdk-lib/aws-codeartifact");
const constructs_1 = require("constructs");
const validations = require("./validations");
/**
 * A Construct that will allow easy setup of an AWS CodeArtifact Repository within a domain
 *
 * @deprecated CodeArtifact class is replaced by Domain and will be removed in future major release 1.1.0
 */
class CodeArtifact extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.repositories = [];
        this.props = props;
        validations.validateDomainNameLength(props.domainName);
        validations.validateDomainName(props.domainName);
        this.domainInstance = new aws_codeartifact_1.CfnDomain(scope, props.domainName, props);
        if (props.repositories) {
            for (const repoProps of props.repositories) {
                validations.validateRepoNameLength(repoProps.repositoryName);
                validations.validateRepoName(repoProps.repositoryName);
                validations.validateExternalConnections(repoProps.externalConnections);
                const repoName = `${repoProps.repositoryName}`;
                const repo = new aws_codeartifact_1.CfnRepository(scope, repoName, {
                    domainName: this.props.domainName,
                    ...repoProps,
                });
                repo.node.addDependency(this.domainInstance);
                this.repositories.push(repo);
            }
        }
    }
}
exports.CodeArtifact = CodeArtifact;
_a = JSII_RTTI_SYMBOL_1;
CodeArtifact[_a] = { fqn: "cdk-codeartifact.CodeArtifact", version: "1.1.1" };
//# sourceMappingURL=data:application/json;base64,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