"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Domain = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_codeartifact_1 = require("aws-cdk-lib/aws-codeartifact");
const constructs_1 = require("constructs");
const repository_1 = require("./repository");
const validations = require("./validations");
/**
 * CodeArtifact Domain Construct - enables creation of a domain along with zero or more repositories.
 *
 * Can be used to create just a domain by passing in no IDomainRepositoryProps elements
 *
 * @example
 * new Domain(this, 'MyDomain', {
 *   domainName: 'my-domain',
 *   repositories: [{
 *     repositoryName: 'my-repo',
 *     externalConnections: [ExternalRepository.NPM]
 *   }]
 * });
 */
class Domain extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.repositories = [];
        this.props = props;
        validations.validateDomainNameLength(props.domainName);
        validations.validateDomainName(props.domainName);
        const domainId = `${props.domainName}-cfnDom`;
        this.domainInstance = new aws_codeartifact_1.CfnDomain(this, domainId, props);
        if (props.repositories) {
            for (const repoProps of props.repositories) {
                validations.validateRepoNameLength(repoProps.repositoryName);
                validations.validateRepoName(repoProps.repositoryName);
                validations.validateExternalConnections(repoProps.externalConnections);
                const repoName = `${repoProps.repositoryName}-cfnRepo`;
                const repo = new repository_1.Repository(this, repoName, {
                    domainName: this.props.domainName,
                    ...repoProps,
                });
                repo.node.addDependency(this.domainInstance);
                this.repositories.push(repo);
            }
        }
    }
}
exports.Domain = Domain;
_a = JSII_RTTI_SYMBOL_1;
Domain[_a] = { fqn: "cdk-codeartifact.Domain", version: "1.1.1" };
//# sourceMappingURL=data:application/json;base64,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