"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TooManyExternalConnections = exports.RepositoryNameTooLong = exports.RepositoryNameInvalid = exports.DomainNameInvalid = exports.DomainNameTooLong = void 0;
/**
 * Exception thrown when Domain Name is too long
 */
class DomainNameTooLong extends Error {
    constructor(msg = 'Domain name too long.  Must be no more than 50 characters in length.') {
        super(msg);
        Object.setPrototypeOf(this, DomainNameTooLong.prototype);
    }
}
exports.DomainNameTooLong = DomainNameTooLong;
/**
 * Exception thrown when Domain Name is not valid.
 */
class DomainNameInvalid extends Error {
    constructor(msg = 'Domain name is not valid.  Name must contain lowercase letters, numbers and "-" characters only.') {
        super(msg);
        Object.setPrototypeOf(this, DomainNameInvalid.prototype);
    }
}
exports.DomainNameInvalid = DomainNameInvalid;
/**
 * Exception thrown when Repository Name is not valid
 */
class RepositoryNameInvalid extends Error {
    constructor(msg = 'Repository name is not valid. Name must start with lowercase letter and contain only lowercase letters, numbers and "-" characters.') {
        super(msg);
        Object.setPrototypeOf(this, RepositoryNameInvalid.prototype);
    }
}
exports.RepositoryNameInvalid = RepositoryNameInvalid;
/**
 * Exception thrown when the Repository Name is too long
 */
class RepositoryNameTooLong extends Error {
    constructor(msg = 'Repository name too long.  Must be no more than 100 characters in length.') {
        super(msg);
        Object.setPrototypeOf(this, RepositoryNameTooLong.prototype);
    }
}
exports.RepositoryNameTooLong = RepositoryNameTooLong;
/**
 * Exception thrown when too many external connections are listed in the Repository props.
 */
class TooManyExternalConnections extends Error {
    constructor(msg = 'Too Many external connections.  Can only configure one external connection.') {
        super(msg);
        Object.setPrototypeOf(this, TooManyExternalConnections.prototype);
    }
}
exports.TooManyExternalConnections = TooManyExternalConnections;
//# sourceMappingURL=data:application/json;base64,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