"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.validateDomainName = validateDomainName;
exports.validateDomainNameLength = validateDomainNameLength;
exports.validateRepoNameLength = validateRepoNameLength;
exports.validateRepoName = validateRepoName;
exports.validateExternalConnections = validateExternalConnections;
const exceptions_1 = require("./exceptions");
function validateDomainName(name) {
    const regex = /^[a-z][a-z0-9\-]{0,48}[a-z0-9]{0,2}$/;
    if (!regex.test(name)) {
        throw new exceptions_1.DomainNameInvalid();
    }
    return true;
}
function validateDomainNameLength(name) {
    if (name.length > 50) {
        throw new exceptions_1.DomainNameTooLong();
    }
    return true;
}
function validateRepoNameLength(name) {
    if (name.length > 100) {
        throw new exceptions_1.RepositoryNameTooLong();
    }
    return true;
}
function validateRepoName(name) {
    const regex = /^[a-z][a-z0-9\-]{0,48}[a-z0-9]{0,2}$/;
    if (!regex.test(name)) {
        throw new exceptions_1.RepositoryNameInvalid();
    }
    return true;
}
function validateExternalConnections(connections) {
    if (connections && connections.length > 1) {
        throw new exceptions_1.TooManyExternalConnections();
    }
    return true;
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidmFsaWRhdGlvbnMuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi9zcmMvdmFsaWRhdGlvbnMudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7QUFRQSxnREFRQztBQUVELDREQU1DO0FBRUQsd0RBTUM7QUFFRCw0Q0FRQztBQUVELGtFQU1DO0FBbERELDZDQU1zQjtBQUV0QixTQUFnQixrQkFBa0IsQ0FBQyxJQUFZO0lBQzdDLE1BQU0sS0FBSyxHQUFHLHNDQUFzQyxDQUFDO0lBRXJELElBQUksQ0FBQyxLQUFLLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxFQUFFLENBQUM7UUFDdEIsTUFBTSxJQUFJLDhCQUFpQixFQUFFLENBQUM7SUFDaEMsQ0FBQztJQUVELE9BQU8sSUFBSSxDQUFDO0FBQ2QsQ0FBQztBQUVELFNBQWdCLHdCQUF3QixDQUFDLElBQVk7SUFDbkQsSUFBSSxJQUFJLENBQUMsTUFBTSxHQUFHLEVBQUUsRUFBRSxDQUFDO1FBQ3JCLE1BQU0sSUFBSSw4QkFBaUIsRUFBRSxDQUFDO0lBQ2hDLENBQUM7SUFFRCxPQUFPLElBQUksQ0FBQztBQUNkLENBQUM7QUFFRCxTQUFnQixzQkFBc0IsQ0FBQyxJQUFZO0lBQ2pELElBQUksSUFBSSxDQUFDLE1BQU0sR0FBRyxHQUFHLEVBQUUsQ0FBQztRQUN0QixNQUFNLElBQUksa0NBQXFCLEVBQUUsQ0FBQztJQUNwQyxDQUFDO0lBRUQsT0FBTyxJQUFJLENBQUM7QUFDZCxDQUFDO0FBRUQsU0FBZ0IsZ0JBQWdCLENBQUMsSUFBWTtJQUMzQyxNQUFNLEtBQUssR0FBRyxzQ0FBc0MsQ0FBQztJQUVyRCxJQUFJLENBQUMsS0FBSyxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsRUFBRSxDQUFDO1FBQ3RCLE1BQU0sSUFBSSxrQ0FBcUIsRUFBRSxDQUFDO0lBQ3BDLENBQUM7SUFFRCxPQUFPLElBQUksQ0FBQztBQUNkLENBQUM7QUFFRCxTQUFnQiwyQkFBMkIsQ0FBQyxXQUFrQztJQUM1RSxJQUFJLFdBQVcsSUFBSSxXQUFXLENBQUMsTUFBTSxHQUFHLENBQUMsRUFBRSxDQUFDO1FBQzFDLE1BQU0sSUFBSSx1Q0FBMEIsRUFBRSxDQUFDO0lBQ3pDLENBQUM7SUFFRCxPQUFPLElBQUksQ0FBQztBQUNkLENBQUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQge1xuICBEb21haW5OYW1lSW52YWxpZCxcbiAgRG9tYWluTmFtZVRvb0xvbmcsXG4gIFJlcG9zaXRvcnlOYW1lSW52YWxpZCxcbiAgUmVwb3NpdG9yeU5hbWVUb29Mb25nLFxuICBUb29NYW55RXh0ZXJuYWxDb25uZWN0aW9ucyxcbn0gZnJvbSAnLi9leGNlcHRpb25zJztcblxuZXhwb3J0IGZ1bmN0aW9uIHZhbGlkYXRlRG9tYWluTmFtZShuYW1lOiBzdHJpbmcpIDogYm9vbGVhbiB7XG4gIGNvbnN0IHJlZ2V4ID0gL15bYS16XVthLXowLTlcXC1dezAsNDh9W2EtejAtOV17MCwyfSQvO1xuXG4gIGlmICghcmVnZXgudGVzdChuYW1lKSkge1xuICAgIHRocm93IG5ldyBEb21haW5OYW1lSW52YWxpZCgpO1xuICB9XG5cbiAgcmV0dXJuIHRydWU7XG59XG5cbmV4cG9ydCBmdW5jdGlvbiB2YWxpZGF0ZURvbWFpbk5hbWVMZW5ndGgobmFtZTogc3RyaW5nKSA6IGJvb2xlYW4ge1xuICBpZiAobmFtZS5sZW5ndGggPiA1MCkge1xuICAgIHRocm93IG5ldyBEb21haW5OYW1lVG9vTG9uZygpO1xuICB9XG5cbiAgcmV0dXJuIHRydWU7XG59XG5cbmV4cG9ydCBmdW5jdGlvbiB2YWxpZGF0ZVJlcG9OYW1lTGVuZ3RoKG5hbWU6IHN0cmluZykgOiBib29sZWFuIHtcbiAgaWYgKG5hbWUubGVuZ3RoID4gMTAwKSB7XG4gICAgdGhyb3cgbmV3IFJlcG9zaXRvcnlOYW1lVG9vTG9uZygpO1xuICB9XG5cbiAgcmV0dXJuIHRydWU7XG59XG5cbmV4cG9ydCBmdW5jdGlvbiB2YWxpZGF0ZVJlcG9OYW1lKG5hbWU6IHN0cmluZyk6IGJvb2xlYW4ge1xuICBjb25zdCByZWdleCA9IC9eW2Etel1bYS16MC05XFwtXXswLDQ4fVthLXowLTldezAsMn0kLztcblxuICBpZiAoIXJlZ2V4LnRlc3QobmFtZSkpIHtcbiAgICB0aHJvdyBuZXcgUmVwb3NpdG9yeU5hbWVJbnZhbGlkKCk7XG4gIH1cblxuICByZXR1cm4gdHJ1ZTtcbn1cblxuZXhwb3J0IGZ1bmN0aW9uIHZhbGlkYXRlRXh0ZXJuYWxDb25uZWN0aW9ucyhjb25uZWN0aW9ucyA6IHN0cmluZ1tdIHwgdW5kZWZpbmVkKSB7XG4gIGlmIChjb25uZWN0aW9ucyAmJiBjb25uZWN0aW9ucy5sZW5ndGggPiAxKSB7XG4gICAgdGhyb3cgbmV3IFRvb01hbnlFeHRlcm5hbENvbm5lY3Rpb25zKCk7XG4gIH1cblxuICByZXR1cm4gdHJ1ZTtcbn1cbiJdfQ==