# coding: utf-8

"""
    Humanloop API

    The Humanloop API allows you to interact with Humanloop from your product or service.  You can do this through HTTP requests from any language or via our official Python or TypeScript SDK.  To install the official [Python SDK](https://pypi.org/project/humanloop/), run the following command:  ```bash pip install humanloop ```  To install the official [TypeScript SDK](https://www.npmjs.com/package/humanloop), run the following command:  ```bash npm i humanloop ```  ---  Guides and further details about key concepts can be found in [our docs](https://docs.humanloop.com/).

    The version of the OpenAPI document: 4.0.1
    Generated by: https://konfigthis.com
"""

from datetime import date, datetime  # noqa: F401
import decimal  # noqa: F401
import functools  # noqa: F401
import io  # noqa: F401
import re  # noqa: F401
import typing  # noqa: F401
import typing_extensions  # noqa: F401
import uuid  # noqa: F401

import frozendict  # noqa: F401

from humanloop import schemas  # noqa: F401


class CreateEvaluationRequest(
    schemas.DictSchema
):
    """
    This class is auto generated by Konfig (https://konfigthis.com)
    """


    class MetaOapg:
        required = {
            "config_id",
            "dataset_id",
            "evaluator_ids",
        }
        
        class properties:
            config_id = schemas.StrSchema
        
            @staticmethod
            def evaluator_ids() -> typing.Type['CreateEvaluationRequestEvaluatorIds']:
                return CreateEvaluationRequestEvaluatorIds
            dataset_id = schemas.StrSchema
        
            @staticmethod
            def provider_api_keys() -> typing.Type['ProviderApiKeys']:
                return ProviderApiKeys
            max_concurrency = schemas.IntSchema
            hl_generated = schemas.BoolSchema
            __annotations__ = {
                "config_id": config_id,
                "evaluator_ids": evaluator_ids,
                "dataset_id": dataset_id,
                "provider_api_keys": provider_api_keys,
                "max_concurrency": max_concurrency,
                "hl_generated": hl_generated,
            }
    
    config_id: MetaOapg.properties.config_id
    dataset_id: MetaOapg.properties.dataset_id
    evaluator_ids: 'CreateEvaluationRequestEvaluatorIds'
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["config_id"]) -> MetaOapg.properties.config_id: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["evaluator_ids"]) -> 'CreateEvaluationRequestEvaluatorIds': ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["dataset_id"]) -> MetaOapg.properties.dataset_id: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["provider_api_keys"]) -> 'ProviderApiKeys': ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["max_concurrency"]) -> MetaOapg.properties.max_concurrency: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["hl_generated"]) -> MetaOapg.properties.hl_generated: ...
    
    @typing.overload
    def __getitem__(self, name: str) -> schemas.UnsetAnyTypeSchema: ...
    
    def __getitem__(self, name: typing.Union[typing_extensions.Literal["config_id", "evaluator_ids", "dataset_id", "provider_api_keys", "max_concurrency", "hl_generated", ], str]):
        # dict_instance[name] accessor
        return super().__getitem__(name)
    
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["config_id"]) -> MetaOapg.properties.config_id: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["evaluator_ids"]) -> 'CreateEvaluationRequestEvaluatorIds': ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["dataset_id"]) -> MetaOapg.properties.dataset_id: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["provider_api_keys"]) -> typing.Union['ProviderApiKeys', schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["max_concurrency"]) -> typing.Union[MetaOapg.properties.max_concurrency, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["hl_generated"]) -> typing.Union[MetaOapg.properties.hl_generated, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: str) -> typing.Union[schemas.UnsetAnyTypeSchema, schemas.Unset]: ...
    
    def get_item_oapg(self, name: typing.Union[typing_extensions.Literal["config_id", "evaluator_ids", "dataset_id", "provider_api_keys", "max_concurrency", "hl_generated", ], str]):
        return super().get_item_oapg(name)
    

    def __new__(
        cls,
        *args: typing.Union[dict, frozendict.frozendict, ],
        config_id: typing.Union[MetaOapg.properties.config_id, str, ],
        dataset_id: typing.Union[MetaOapg.properties.dataset_id, str, ],
        evaluator_ids: 'CreateEvaluationRequestEvaluatorIds',
        provider_api_keys: typing.Union['ProviderApiKeys', schemas.Unset] = schemas.unset,
        max_concurrency: typing.Union[MetaOapg.properties.max_concurrency, decimal.Decimal, int, schemas.Unset] = schemas.unset,
        hl_generated: typing.Union[MetaOapg.properties.hl_generated, bool, schemas.Unset] = schemas.unset,
        _configuration: typing.Optional[schemas.Configuration] = None,
        **kwargs: typing.Union[schemas.AnyTypeSchema, dict, frozendict.frozendict, str, date, datetime, uuid.UUID, int, float, decimal.Decimal, None, list, tuple, bytes],
    ) -> 'CreateEvaluationRequest':
        return super().__new__(
            cls,
            *args,
            config_id=config_id,
            dataset_id=dataset_id,
            evaluator_ids=evaluator_ids,
            provider_api_keys=provider_api_keys,
            max_concurrency=max_concurrency,
            hl_generated=hl_generated,
            _configuration=_configuration,
            **kwargs,
        )

from humanloop.model.create_evaluation_request_evaluator_ids import CreateEvaluationRequestEvaluatorIds
from humanloop.model.provider_api_keys import ProviderApiKeys
