# coding: utf-8

"""
    Humanloop API

    The Humanloop API allows you to interact with Humanloop from your product or service.  You can do this through HTTP requests from any language or via our official Python or TypeScript SDK.  To install the official [Python SDK](https://pypi.org/project/humanloop/), run the following command:  ```bash pip install humanloop ```  To install the official [TypeScript SDK](https://www.npmjs.com/package/humanloop), run the following command:  ```bash npm i humanloop ```  ---  Guides and further details about key concepts can be found in [our docs](https://docs.humanloop.com/).

    The version of the OpenAPI document: 4.0.1
    Generated by: https://konfigthis.com
"""

from datetime import date, datetime  # noqa: F401
import decimal  # noqa: F401
import functools  # noqa: F401
import io  # noqa: F401
import re  # noqa: F401
import typing  # noqa: F401
import typing_extensions  # noqa: F401
import uuid  # noqa: F401

import frozendict  # noqa: F401

from humanloop import schemas  # noqa: F401


class EvaluationResponse(
    schemas.DictSchema
):
    """
    This class is auto generated by Konfig (https://konfigthis.com)
    """


    class MetaOapg:
        required = {
            "updated_at",
            "evaluators",
            "created_at",
            "id",
            "config",
            "dataset",
            "status",
        }
        
        class properties:
            id = schemas.StrSchema
        
            @staticmethod
            def status() -> typing.Type['EvaluationStatus']:
                return EvaluationStatus
        
            @staticmethod
            def config() -> typing.Type['ConfigResponse']:
                return ConfigResponse
            created_at = schemas.DateTimeSchema
            updated_at = schemas.DateTimeSchema
            
            
            class evaluators(
                schemas.ListSchema
            ):
            
            
                class MetaOapg:
                    
                    @staticmethod
                    def items() -> typing.Type['EvaluatorResponse']:
                        return EvaluatorResponse
            
                def __new__(
                    cls,
                    arg: typing.Union[typing.Tuple['EvaluatorResponse'], typing.List['EvaluatorResponse']],
                    _configuration: typing.Optional[schemas.Configuration] = None,
                ) -> 'evaluators':
                    return super().__new__(
                        cls,
                        arg,
                        _configuration=_configuration,
                    )
            
                def __getitem__(self, i: int) -> 'EvaluatorResponse':
                    return super().__getitem__(i)
        
            @staticmethod
            def dataset() -> typing.Type['DatasetResponse']:
                return DatasetResponse
        
            @staticmethod
            def dataset_snapshot() -> typing.Type['DatasetResponse']:
                return DatasetResponse
            
            
            class evaluator_aggregates(
                schemas.ListSchema
            ):
            
            
                class MetaOapg:
                    
                    @staticmethod
                    def items() -> typing.Type['ModelConfigEvaluatorAggregateResponse']:
                        return ModelConfigEvaluatorAggregateResponse
            
                def __new__(
                    cls,
                    arg: typing.Union[typing.Tuple['ModelConfigEvaluatorAggregateResponse'], typing.List['ModelConfigEvaluatorAggregateResponse']],
                    _configuration: typing.Optional[schemas.Configuration] = None,
                ) -> 'evaluator_aggregates':
                    return super().__new__(
                        cls,
                        arg,
                        _configuration=_configuration,
                    )
            
                def __getitem__(self, i: int) -> 'ModelConfigEvaluatorAggregateResponse':
                    return super().__getitem__(i)
        
            @staticmethod
            def feedback_aggregates() -> typing.Type['FeedbackAggregateResponse']:
                return FeedbackAggregateResponse
            __annotations__ = {
                "id": id,
                "status": status,
                "config": config,
                "created_at": created_at,
                "updated_at": updated_at,
                "evaluators": evaluators,
                "dataset": dataset,
                "dataset_snapshot": dataset_snapshot,
                "evaluator_aggregates": evaluator_aggregates,
                "feedback_aggregates": feedback_aggregates,
            }
    
    updated_at: MetaOapg.properties.updated_at
    evaluators: MetaOapg.properties.evaluators
    created_at: MetaOapg.properties.created_at
    id: MetaOapg.properties.id
    config: 'ConfigResponse'
    dataset: 'DatasetResponse'
    status: 'EvaluationStatus'
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["id"]) -> MetaOapg.properties.id: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["status"]) -> 'EvaluationStatus': ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["config"]) -> 'ConfigResponse': ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["created_at"]) -> MetaOapg.properties.created_at: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["updated_at"]) -> MetaOapg.properties.updated_at: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["evaluators"]) -> MetaOapg.properties.evaluators: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["dataset"]) -> 'DatasetResponse': ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["dataset_snapshot"]) -> 'DatasetResponse': ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["evaluator_aggregates"]) -> MetaOapg.properties.evaluator_aggregates: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["feedback_aggregates"]) -> 'FeedbackAggregateResponse': ...
    
    @typing.overload
    def __getitem__(self, name: str) -> schemas.UnsetAnyTypeSchema: ...
    
    def __getitem__(self, name: typing.Union[typing_extensions.Literal["id", "status", "config", "created_at", "updated_at", "evaluators", "dataset", "dataset_snapshot", "evaluator_aggregates", "feedback_aggregates", ], str]):
        # dict_instance[name] accessor
        return super().__getitem__(name)
    
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["id"]) -> MetaOapg.properties.id: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["status"]) -> 'EvaluationStatus': ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["config"]) -> 'ConfigResponse': ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["created_at"]) -> MetaOapg.properties.created_at: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["updated_at"]) -> MetaOapg.properties.updated_at: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["evaluators"]) -> MetaOapg.properties.evaluators: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["dataset"]) -> 'DatasetResponse': ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["dataset_snapshot"]) -> typing.Union['DatasetResponse', schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["evaluator_aggregates"]) -> typing.Union[MetaOapg.properties.evaluator_aggregates, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["feedback_aggregates"]) -> typing.Union['FeedbackAggregateResponse', schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: str) -> typing.Union[schemas.UnsetAnyTypeSchema, schemas.Unset]: ...
    
    def get_item_oapg(self, name: typing.Union[typing_extensions.Literal["id", "status", "config", "created_at", "updated_at", "evaluators", "dataset", "dataset_snapshot", "evaluator_aggregates", "feedback_aggregates", ], str]):
        return super().get_item_oapg(name)
    

    def __new__(
        cls,
        *args: typing.Union[dict, frozendict.frozendict, ],
        updated_at: typing.Union[MetaOapg.properties.updated_at, str, datetime, ],
        evaluators: typing.Union[MetaOapg.properties.evaluators, list, tuple, ],
        created_at: typing.Union[MetaOapg.properties.created_at, str, datetime, ],
        id: typing.Union[MetaOapg.properties.id, str, ],
        config: 'ConfigResponse',
        dataset: 'DatasetResponse',
        status: 'EvaluationStatus',
        dataset_snapshot: typing.Union['DatasetResponse', schemas.Unset] = schemas.unset,
        evaluator_aggregates: typing.Union[MetaOapg.properties.evaluator_aggregates, list, tuple, schemas.Unset] = schemas.unset,
        feedback_aggregates: typing.Union['FeedbackAggregateResponse', schemas.Unset] = schemas.unset,
        _configuration: typing.Optional[schemas.Configuration] = None,
        **kwargs: typing.Union[schemas.AnyTypeSchema, dict, frozendict.frozendict, str, date, datetime, uuid.UUID, int, float, decimal.Decimal, None, list, tuple, bytes],
    ) -> 'EvaluationResponse':
        return super().__new__(
            cls,
            *args,
            updated_at=updated_at,
            evaluators=evaluators,
            created_at=created_at,
            id=id,
            config=config,
            dataset=dataset,
            status=status,
            dataset_snapshot=dataset_snapshot,
            evaluator_aggregates=evaluator_aggregates,
            feedback_aggregates=feedback_aggregates,
            _configuration=_configuration,
            **kwargs,
        )

from humanloop.model.config_response import ConfigResponse
from humanloop.model.dataset_response import DatasetResponse
from humanloop.model.evaluation_status import EvaluationStatus
from humanloop.model.evaluator_response import EvaluatorResponse
from humanloop.model.feedback_aggregate_response import FeedbackAggregateResponse
from humanloop.model.model_config_evaluator_aggregate_response import ModelConfigEvaluatorAggregateResponse
