# coding: utf-8

"""
    Humanloop API

    The Humanloop API allows you to interact with Humanloop from your product or service.  You can do this through HTTP requests from any language or via our official Python or TypeScript SDK.  To install the official [Python SDK](https://pypi.org/project/humanloop/), run the following command:  ```bash pip install humanloop ```  To install the official [TypeScript SDK](https://www.npmjs.com/package/humanloop), run the following command:  ```bash npm i humanloop ```  ---  Guides and further details about key concepts can be found in [our docs](https://docs.humanloop.com/).

    The version of the OpenAPI document: 4.0.1
    Generated by: https://konfigthis.com
"""

from datetime import date, datetime  # noqa: F401
import decimal  # noqa: F401
import functools  # noqa: F401
import io  # noqa: F401
import re  # noqa: F401
import typing  # noqa: F401
import typing_extensions  # noqa: F401
import uuid  # noqa: F401

import frozendict  # noqa: F401

from humanloop import schemas  # noqa: F401


class ExperimentResponse(
    schemas.DictSchema
):
    """
    This class is auto generated by Konfig (https://konfigthis.com)
    """


    class MetaOapg:
        required = {
            "positive_labels",
            "updated_at",
            "metric",
            "project_id",
            "name",
            "created_at",
            "id",
            "status",
        }
        
        class properties:
            id = schemas.StrSchema
            project_id = schemas.StrSchema
            name = schemas.StrSchema
        
            @staticmethod
            def status() -> typing.Type['ExperimentStatus']:
                return ExperimentStatus
        
            @staticmethod
            def metric() -> typing.Type['BaseMetricResponse']:
                return BaseMetricResponse
            
            
            class positive_labels(
                schemas.ListSchema
            ):
            
            
                class MetaOapg:
                    
                    @staticmethod
                    def items() -> typing.Type['PositiveLabel']:
                        return PositiveLabel
            
                def __new__(
                    cls,
                    arg: typing.Union[typing.Tuple['PositiveLabel'], typing.List['PositiveLabel']],
                    _configuration: typing.Optional[schemas.Configuration] = None,
                ) -> 'positive_labels':
                    return super().__new__(
                        cls,
                        arg,
                        _configuration=_configuration,
                    )
            
                def __getitem__(self, i: int) -> 'PositiveLabel':
                    return super().__getitem__(i)
            created_at = schemas.DateTimeSchema
            updated_at = schemas.DateTimeSchema
            
            
            class configs(
                schemas.ListSchema
            ):
            
            
                class MetaOapg:
                    
                    @staticmethod
                    def items() -> typing.Type['ExperimentConfigResponse']:
                        return ExperimentConfigResponse
            
                def __new__(
                    cls,
                    arg: typing.Union[typing.Tuple['ExperimentConfigResponse'], typing.List['ExperimentConfigResponse']],
                    _configuration: typing.Optional[schemas.Configuration] = None,
                ) -> 'configs':
                    return super().__new__(
                        cls,
                        arg,
                        _configuration=_configuration,
                    )
            
                def __getitem__(self, i: int) -> 'ExperimentConfigResponse':
                    return super().__getitem__(i)
            __annotations__ = {
                "id": id,
                "project_id": project_id,
                "name": name,
                "status": status,
                "metric": metric,
                "positive_labels": positive_labels,
                "created_at": created_at,
                "updated_at": updated_at,
                "configs": configs,
            }
    
    positive_labels: MetaOapg.properties.positive_labels
    updated_at: MetaOapg.properties.updated_at
    metric: 'BaseMetricResponse'
    project_id: MetaOapg.properties.project_id
    name: MetaOapg.properties.name
    created_at: MetaOapg.properties.created_at
    id: MetaOapg.properties.id
    status: 'ExperimentStatus'
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["id"]) -> MetaOapg.properties.id: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["project_id"]) -> MetaOapg.properties.project_id: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["name"]) -> MetaOapg.properties.name: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["status"]) -> 'ExperimentStatus': ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["metric"]) -> 'BaseMetricResponse': ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["positive_labels"]) -> MetaOapg.properties.positive_labels: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["created_at"]) -> MetaOapg.properties.created_at: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["updated_at"]) -> MetaOapg.properties.updated_at: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["configs"]) -> MetaOapg.properties.configs: ...
    
    @typing.overload
    def __getitem__(self, name: str) -> schemas.UnsetAnyTypeSchema: ...
    
    def __getitem__(self, name: typing.Union[typing_extensions.Literal["id", "project_id", "name", "status", "metric", "positive_labels", "created_at", "updated_at", "configs", ], str]):
        # dict_instance[name] accessor
        return super().__getitem__(name)
    
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["id"]) -> MetaOapg.properties.id: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["project_id"]) -> MetaOapg.properties.project_id: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["name"]) -> MetaOapg.properties.name: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["status"]) -> 'ExperimentStatus': ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["metric"]) -> 'BaseMetricResponse': ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["positive_labels"]) -> MetaOapg.properties.positive_labels: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["created_at"]) -> MetaOapg.properties.created_at: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["updated_at"]) -> MetaOapg.properties.updated_at: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["configs"]) -> typing.Union[MetaOapg.properties.configs, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: str) -> typing.Union[schemas.UnsetAnyTypeSchema, schemas.Unset]: ...
    
    def get_item_oapg(self, name: typing.Union[typing_extensions.Literal["id", "project_id", "name", "status", "metric", "positive_labels", "created_at", "updated_at", "configs", ], str]):
        return super().get_item_oapg(name)
    

    def __new__(
        cls,
        *args: typing.Union[dict, frozendict.frozendict, ],
        positive_labels: typing.Union[MetaOapg.properties.positive_labels, list, tuple, ],
        updated_at: typing.Union[MetaOapg.properties.updated_at, str, datetime, ],
        metric: 'BaseMetricResponse',
        project_id: typing.Union[MetaOapg.properties.project_id, str, ],
        name: typing.Union[MetaOapg.properties.name, str, ],
        created_at: typing.Union[MetaOapg.properties.created_at, str, datetime, ],
        id: typing.Union[MetaOapg.properties.id, str, ],
        status: 'ExperimentStatus',
        configs: typing.Union[MetaOapg.properties.configs, list, tuple, schemas.Unset] = schemas.unset,
        _configuration: typing.Optional[schemas.Configuration] = None,
        **kwargs: typing.Union[schemas.AnyTypeSchema, dict, frozendict.frozendict, str, date, datetime, uuid.UUID, int, float, decimal.Decimal, None, list, tuple, bytes],
    ) -> 'ExperimentResponse':
        return super().__new__(
            cls,
            *args,
            positive_labels=positive_labels,
            updated_at=updated_at,
            metric=metric,
            project_id=project_id,
            name=name,
            created_at=created_at,
            id=id,
            status=status,
            configs=configs,
            _configuration=_configuration,
            **kwargs,
        )

from humanloop.model.base_metric_response import BaseMetricResponse
from humanloop.model.experiment_config_response import ExperimentConfigResponse
from humanloop.model.experiment_status import ExperimentStatus
from humanloop.model.positive_label import PositiveLabel
