# coding: utf-8

"""
    Humanloop API

    The Humanloop API allows you to interact with Humanloop from your product or service.  You can do this through HTTP requests from any language or via our official Python or TypeScript SDK.  To install the official [Python SDK](https://pypi.org/project/humanloop/), run the following command:  ```bash pip install humanloop ```  To install the official [TypeScript SDK](https://www.npmjs.com/package/humanloop), run the following command:  ```bash npm i humanloop ```  ---  Guides and further details about key concepts can be found in [our docs](https://docs.humanloop.com/).

    The version of the OpenAPI document: 4.0.1
    Generated by: https://konfigthis.com
"""

from datetime import date, datetime  # noqa: F401
import decimal  # noqa: F401
import functools  # noqa: F401
import io  # noqa: F401
import re  # noqa: F401
import typing  # noqa: F401
import typing_extensions  # noqa: F401
import uuid  # noqa: F401

import frozendict  # noqa: F401

from humanloop import schemas  # noqa: F401


class FinetuneResponse(
    schemas.DictSchema
):
    """
    This class is auto generated by Konfig (https://konfigthis.com)
    """


    class MetaOapg:
        required = {
            "updated_at",
            "name",
            "created_at",
            "id",
            "config",
            "dataset",
            "status",
        }
        
        class properties:
            id = schemas.StrSchema
            name = schemas.StrSchema
            status = schemas.StrSchema
        
            @staticmethod
            def config() -> typing.Type['FinetuneConfig']:
                return FinetuneConfig
        
            @staticmethod
            def dataset() -> typing.Type['DatasetResponse']:
                return DatasetResponse
            created_at = schemas.DateTimeSchema
            updated_at = schemas.DateTimeSchema
            model_name = schemas.StrSchema
            metadata = schemas.DictSchema
            provider_id = schemas.StrSchema
            provider_details = schemas.DictSchema
            data_summary = schemas.DictSchema
            __annotations__ = {
                "id": id,
                "name": name,
                "status": status,
                "config": config,
                "dataset": dataset,
                "created_at": created_at,
                "updated_at": updated_at,
                "model_name": model_name,
                "metadata": metadata,
                "provider_id": provider_id,
                "provider_details": provider_details,
                "data_summary": data_summary,
            }
    
    updated_at: MetaOapg.properties.updated_at
    name: MetaOapg.properties.name
    created_at: MetaOapg.properties.created_at
    id: MetaOapg.properties.id
    config: 'FinetuneConfig'
    dataset: 'DatasetResponse'
    status: MetaOapg.properties.status
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["id"]) -> MetaOapg.properties.id: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["name"]) -> MetaOapg.properties.name: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["status"]) -> MetaOapg.properties.status: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["config"]) -> 'FinetuneConfig': ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["dataset"]) -> 'DatasetResponse': ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["created_at"]) -> MetaOapg.properties.created_at: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["updated_at"]) -> MetaOapg.properties.updated_at: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["model_name"]) -> MetaOapg.properties.model_name: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["metadata"]) -> MetaOapg.properties.metadata: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["provider_id"]) -> MetaOapg.properties.provider_id: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["provider_details"]) -> MetaOapg.properties.provider_details: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["data_summary"]) -> MetaOapg.properties.data_summary: ...
    
    @typing.overload
    def __getitem__(self, name: str) -> schemas.UnsetAnyTypeSchema: ...
    
    def __getitem__(self, name: typing.Union[typing_extensions.Literal["id", "name", "status", "config", "dataset", "created_at", "updated_at", "model_name", "metadata", "provider_id", "provider_details", "data_summary", ], str]):
        # dict_instance[name] accessor
        return super().__getitem__(name)
    
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["id"]) -> MetaOapg.properties.id: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["name"]) -> MetaOapg.properties.name: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["status"]) -> MetaOapg.properties.status: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["config"]) -> 'FinetuneConfig': ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["dataset"]) -> 'DatasetResponse': ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["created_at"]) -> MetaOapg.properties.created_at: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["updated_at"]) -> MetaOapg.properties.updated_at: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["model_name"]) -> typing.Union[MetaOapg.properties.model_name, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["metadata"]) -> typing.Union[MetaOapg.properties.metadata, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["provider_id"]) -> typing.Union[MetaOapg.properties.provider_id, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["provider_details"]) -> typing.Union[MetaOapg.properties.provider_details, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["data_summary"]) -> typing.Union[MetaOapg.properties.data_summary, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: str) -> typing.Union[schemas.UnsetAnyTypeSchema, schemas.Unset]: ...
    
    def get_item_oapg(self, name: typing.Union[typing_extensions.Literal["id", "name", "status", "config", "dataset", "created_at", "updated_at", "model_name", "metadata", "provider_id", "provider_details", "data_summary", ], str]):
        return super().get_item_oapg(name)
    

    def __new__(
        cls,
        *args: typing.Union[dict, frozendict.frozendict, ],
        updated_at: typing.Union[MetaOapg.properties.updated_at, str, datetime, ],
        name: typing.Union[MetaOapg.properties.name, str, ],
        created_at: typing.Union[MetaOapg.properties.created_at, str, datetime, ],
        id: typing.Union[MetaOapg.properties.id, str, ],
        config: 'FinetuneConfig',
        dataset: 'DatasetResponse',
        status: typing.Union[MetaOapg.properties.status, str, ],
        model_name: typing.Union[MetaOapg.properties.model_name, str, schemas.Unset] = schemas.unset,
        metadata: typing.Union[MetaOapg.properties.metadata, dict, frozendict.frozendict, schemas.Unset] = schemas.unset,
        provider_id: typing.Union[MetaOapg.properties.provider_id, str, schemas.Unset] = schemas.unset,
        provider_details: typing.Union[MetaOapg.properties.provider_details, dict, frozendict.frozendict, schemas.Unset] = schemas.unset,
        data_summary: typing.Union[MetaOapg.properties.data_summary, dict, frozendict.frozendict, schemas.Unset] = schemas.unset,
        _configuration: typing.Optional[schemas.Configuration] = None,
        **kwargs: typing.Union[schemas.AnyTypeSchema, dict, frozendict.frozendict, str, date, datetime, uuid.UUID, int, float, decimal.Decimal, None, list, tuple, bytes],
    ) -> 'FinetuneResponse':
        return super().__new__(
            cls,
            *args,
            updated_at=updated_at,
            name=name,
            created_at=created_at,
            id=id,
            config=config,
            dataset=dataset,
            status=status,
            model_name=model_name,
            metadata=metadata,
            provider_id=provider_id,
            provider_details=provider_details,
            data_summary=data_summary,
            _configuration=_configuration,
            **kwargs,
        )

from humanloop.model.dataset_response import DatasetResponse
from humanloop.model.finetune_config import FinetuneConfig
