# coding: utf-8

"""
    Humanloop API

    The Humanloop API allows you to interact with Humanloop from your product or service.  You can do this through HTTP requests from any language or via our official Python or TypeScript SDK.  To install the official [Python SDK](https://pypi.org/project/humanloop/), run the following command:  ```bash pip install humanloop ```  To install the official [TypeScript SDK](https://www.npmjs.com/package/humanloop), run the following command:  ```bash npm i humanloop ```  ---  Guides and further details about key concepts can be found in [our docs](https://docs.humanloop.com/).

    The version of the OpenAPI document: 4.0.1
    Generated by: https://konfigthis.com
"""

from datetime import date, datetime  # noqa: F401
import decimal  # noqa: F401
import functools  # noqa: F401
import io  # noqa: F401
import re  # noqa: F401
import typing  # noqa: F401
import typing_extensions  # noqa: F401
import uuid  # noqa: F401

import frozendict  # noqa: F401

from humanloop import schemas  # noqa: F401


class ProjectConfigResponse(
    schemas.DictSchema
):
    """
    This class is auto generated by Konfig (https://konfigthis.com)
    """


    class MetaOapg:
        required = {
            "updated_at",
            "project_id",
            "last_used",
            "created_at",
            "project_name",
            "config",
        }
        
        class properties:
            project_id = schemas.StrSchema
            project_name = schemas.StrSchema
            created_at = schemas.DateTimeSchema
            updated_at = schemas.DateTimeSchema
            last_used = schemas.DateTimeSchema
        
            @staticmethod
            def config() -> typing.Type['ConfigResponse']:
                return ConfigResponse
            
            
            class feedback_stats(
                schemas.ListSchema
            ):
            
            
                class MetaOapg:
                    
                    @staticmethod
                    def items() -> typing.Type['ProjectModelConfigFeedbackStatsResponse']:
                        return ProjectModelConfigFeedbackStatsResponse
            
                def __new__(
                    cls,
                    arg: typing.Union[typing.Tuple['ProjectModelConfigFeedbackStatsResponse'], typing.List['ProjectModelConfigFeedbackStatsResponse']],
                    _configuration: typing.Optional[schemas.Configuration] = None,
                ) -> 'feedback_stats':
                    return super().__new__(
                        cls,
                        arg,
                        _configuration=_configuration,
                    )
            
                def __getitem__(self, i: int) -> 'ProjectModelConfigFeedbackStatsResponse':
                    return super().__getitem__(i)
            num_datapoints = schemas.IntSchema
            experiment_id = schemas.StrSchema
            
            
            class evaluation_aggregates(
                schemas.ListSchema
            ):
            
            
                class MetaOapg:
                    
                    @staticmethod
                    def items() -> typing.Type['ModelConfigEvaluatorAggregateResponse']:
                        return ModelConfigEvaluatorAggregateResponse
            
                def __new__(
                    cls,
                    arg: typing.Union[typing.Tuple['ModelConfigEvaluatorAggregateResponse'], typing.List['ModelConfigEvaluatorAggregateResponse']],
                    _configuration: typing.Optional[schemas.Configuration] = None,
                ) -> 'evaluation_aggregates':
                    return super().__new__(
                        cls,
                        arg,
                        _configuration=_configuration,
                    )
            
                def __getitem__(self, i: int) -> 'ModelConfigEvaluatorAggregateResponse':
                    return super().__getitem__(i)
            __annotations__ = {
                "project_id": project_id,
                "project_name": project_name,
                "created_at": created_at,
                "updated_at": updated_at,
                "last_used": last_used,
                "config": config,
                "feedback_stats": feedback_stats,
                "num_datapoints": num_datapoints,
                "experiment_id": experiment_id,
                "evaluation_aggregates": evaluation_aggregates,
            }
    
    updated_at: MetaOapg.properties.updated_at
    project_id: MetaOapg.properties.project_id
    last_used: MetaOapg.properties.last_used
    created_at: MetaOapg.properties.created_at
    project_name: MetaOapg.properties.project_name
    config: 'ConfigResponse'
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["project_id"]) -> MetaOapg.properties.project_id: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["project_name"]) -> MetaOapg.properties.project_name: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["created_at"]) -> MetaOapg.properties.created_at: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["updated_at"]) -> MetaOapg.properties.updated_at: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["last_used"]) -> MetaOapg.properties.last_used: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["config"]) -> 'ConfigResponse': ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["feedback_stats"]) -> MetaOapg.properties.feedback_stats: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["num_datapoints"]) -> MetaOapg.properties.num_datapoints: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["experiment_id"]) -> MetaOapg.properties.experiment_id: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["evaluation_aggregates"]) -> MetaOapg.properties.evaluation_aggregates: ...
    
    @typing.overload
    def __getitem__(self, name: str) -> schemas.UnsetAnyTypeSchema: ...
    
    def __getitem__(self, name: typing.Union[typing_extensions.Literal["project_id", "project_name", "created_at", "updated_at", "last_used", "config", "feedback_stats", "num_datapoints", "experiment_id", "evaluation_aggregates", ], str]):
        # dict_instance[name] accessor
        return super().__getitem__(name)
    
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["project_id"]) -> MetaOapg.properties.project_id: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["project_name"]) -> MetaOapg.properties.project_name: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["created_at"]) -> MetaOapg.properties.created_at: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["updated_at"]) -> MetaOapg.properties.updated_at: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["last_used"]) -> MetaOapg.properties.last_used: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["config"]) -> 'ConfigResponse': ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["feedback_stats"]) -> typing.Union[MetaOapg.properties.feedback_stats, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["num_datapoints"]) -> typing.Union[MetaOapg.properties.num_datapoints, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["experiment_id"]) -> typing.Union[MetaOapg.properties.experiment_id, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["evaluation_aggregates"]) -> typing.Union[MetaOapg.properties.evaluation_aggregates, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: str) -> typing.Union[schemas.UnsetAnyTypeSchema, schemas.Unset]: ...
    
    def get_item_oapg(self, name: typing.Union[typing_extensions.Literal["project_id", "project_name", "created_at", "updated_at", "last_used", "config", "feedback_stats", "num_datapoints", "experiment_id", "evaluation_aggregates", ], str]):
        return super().get_item_oapg(name)
    

    def __new__(
        cls,
        *args: typing.Union[dict, frozendict.frozendict, ],
        updated_at: typing.Union[MetaOapg.properties.updated_at, str, datetime, ],
        project_id: typing.Union[MetaOapg.properties.project_id, str, ],
        last_used: typing.Union[MetaOapg.properties.last_used, str, datetime, ],
        created_at: typing.Union[MetaOapg.properties.created_at, str, datetime, ],
        project_name: typing.Union[MetaOapg.properties.project_name, str, ],
        config: 'ConfigResponse',
        feedback_stats: typing.Union[MetaOapg.properties.feedback_stats, list, tuple, schemas.Unset] = schemas.unset,
        num_datapoints: typing.Union[MetaOapg.properties.num_datapoints, decimal.Decimal, int, schemas.Unset] = schemas.unset,
        experiment_id: typing.Union[MetaOapg.properties.experiment_id, str, schemas.Unset] = schemas.unset,
        evaluation_aggregates: typing.Union[MetaOapg.properties.evaluation_aggregates, list, tuple, schemas.Unset] = schemas.unset,
        _configuration: typing.Optional[schemas.Configuration] = None,
        **kwargs: typing.Union[schemas.AnyTypeSchema, dict, frozendict.frozendict, str, date, datetime, uuid.UUID, int, float, decimal.Decimal, None, list, tuple, bytes],
    ) -> 'ProjectConfigResponse':
        return super().__new__(
            cls,
            *args,
            updated_at=updated_at,
            project_id=project_id,
            last_used=last_used,
            created_at=created_at,
            project_name=project_name,
            config=config,
            feedback_stats=feedback_stats,
            num_datapoints=num_datapoints,
            experiment_id=experiment_id,
            evaluation_aggregates=evaluation_aggregates,
            _configuration=_configuration,
            **kwargs,
        )

from humanloop.model.config_response import ConfigResponse
from humanloop.model.model_config_evaluator_aggregate_response import ModelConfigEvaluatorAggregateResponse
from humanloop.model.project_model_config_feedback_stats_response import ProjectModelConfigFeedbackStatsResponse
