# coding: utf-8

"""
    Humanloop API

    The Humanloop API allows you to interact with Humanloop from your product or service.  You can do this through HTTP requests from any language or via our official Python or TypeScript SDK.  To install the official [Python SDK](https://pypi.org/project/humanloop/), run the following command:  ```bash pip install humanloop ```  To install the official [TypeScript SDK](https://www.npmjs.com/package/humanloop), run the following command:  ```bash npm i humanloop ```  ---  Guides and further details about key concepts can be found in [our docs](https://docs.humanloop.com/).

    The version of the OpenAPI document: 4.0.1
    Generated by: https://konfigthis.com
"""

from datetime import datetime, date
import typing
from enum import Enum
from typing_extensions import TypedDict, Literal, TYPE_CHECKING
from pydantic import BaseModel, Field, RootModel

from humanloop.pydantic.model_config_request import ModelConfigRequest
from humanloop.pydantic.tool_config_request import ToolConfigRequest
from humanloop.pydantic.user_response import UserResponse

class AgentConfigResponse(BaseModel):
    # String ID of config. Starts with `config_`.
    id: str = Field(alias='id')

    type: Literal["agent"] = Field(alias='type')

    # Whether the config is committed or not.
    status: str = Field(alias='status')

    # Name of config.
    name: str = Field(alias='name')

    # Class of the agent.
    agent_class: str = Field(alias='agent_class')

    # Model config associated with the agent.
    model_config_: ModelConfigRequest = Field(alias='model_config')

    # Description of config.
    description: typing.Optional[str] = Field(None, alias='description')

    # Other parameters that define the config.
    other: typing.Optional[typing.Dict[str, typing.Union[bool, date, datetime, dict, float, int, list, str, None]]] = Field(None, alias='other')

    # The user who created the config.
    created_by: typing.Optional[UserResponse] = Field(None, alias='created_by')

    # Tools associated with the agent.
    tools: typing.Optional[typing.List[ToolConfigRequest]] = Field(None, alias='tools')
    class Config:
        arbitrary_types_allowed = True
