# coding: utf-8

"""
    Humanloop API

    The Humanloop API allows you to interact with Humanloop from your product or service.  You can do this through HTTP requests from any language or via our official Python or TypeScript SDK.  To install the official [Python SDK](https://pypi.org/project/humanloop/), run the following command:  ```bash pip install humanloop ```  To install the official [TypeScript SDK](https://www.npmjs.com/package/humanloop), run the following command:  ```bash npm i humanloop ```  ---  Guides and further details about key concepts can be found in [our docs](https://docs.humanloop.com/).

    The version of the OpenAPI document: 4.0.1
    Generated by: https://konfigthis.com
"""

from datetime import datetime, date
import typing
from enum import Enum
from typing_extensions import TypedDict, Literal, TYPE_CHECKING
from pydantic import BaseModel, Field, RootModel

from humanloop.pydantic.completion_response_provider_responses import CompletionResponseProviderResponses
from humanloop.pydantic.data_response import DataResponse
from humanloop.pydantic.usage import Usage

class CompletionResponse(BaseModel):
    # Array containing the generation responses.
    data: typing.List[DataResponse] = Field(alias='data')

    provider_responses: CompletionResponseProviderResponses = Field(alias='provider_responses')

    # Unique identifier of the parent project. Will not be provided if the request was made without providing a project name or id
    project_id: typing.Optional[str] = Field(None, alias='project_id')

    # How many completions to make for each set of inputs.
    num_samples: typing.Optional[int] = Field(None, alias='num_samples')

    # Include the log probabilities of the top n tokens in the provider_response
    logprobs: typing.Optional[int] = Field(None, alias='logprobs')

    # The suffix that comes after a completion of inserted text. Useful for completions that act like inserts.
    suffix: typing.Optional[str] = Field(None, alias='suffix')

    # End-user ID passed through to provider call.
    user: typing.Optional[str] = Field(None, alias='user')

    # Counts of the number of tokens used and related stats.
    usage: typing.Optional[Usage] = Field(None, alias='usage')

    # Any additional metadata to record.
    metadata: typing.Optional[typing.Dict[str, typing.Union[bool, date, datetime, dict, float, int, list, str, None]]] = Field(None, alias='metadata')

    # The raw request sent to the model provider.
    provider_request: typing.Optional[typing.Dict[str, typing.Union[bool, date, datetime, dict, float, int, list, str, None]]] = Field(None, alias='provider_request')

    # ID of the session if it belongs to one.
    session_id: typing.Optional[str] = Field(None, alias='session_id')
    class Config:
        arbitrary_types_allowed = True
