# coding: utf-8

"""
    Humanloop API

    The Humanloop API allows you to interact with Humanloop from your product or service.  You can do this through HTTP requests from any language or via our official Python or TypeScript SDK.  To install the official [Python SDK](https://pypi.org/project/humanloop/), run the following command:  ```bash pip install humanloop ```  To install the official [TypeScript SDK](https://www.npmjs.com/package/humanloop), run the following command:  ```bash npm i humanloop ```  ---  Guides and further details about key concepts can be found in [our docs](https://docs.humanloop.com/).

    The version of the OpenAPI document: 4.0.1
    Generated by: https://konfigthis.com
"""

from datetime import datetime, date
import typing
from enum import Enum
from typing_extensions import TypedDict, Literal, TYPE_CHECKING
from pydantic import BaseModel, Field, RootModel

from humanloop.pydantic.feedback_type_request import FeedbackTypeRequest

class CreateProjectRequest(BaseModel):
    # Unique project name.
    name: str = Field(alias='name')

    # Feedback types to be created.
    feedback_types: typing.Optional[typing.List[FeedbackTypeRequest]] = Field(None, alias='feedback_types')

    # ID of directory to assign project to. Starts with `dir_`. If not provided, the project will be created in the root directory.
    directory_id: typing.Optional[str] = Field(None, alias='directory_id')
    class Config:
        arbitrary_types_allowed = True
