# coding: utf-8

"""
    Humanloop API

    The Humanloop API allows you to interact with Humanloop from your product or service.  You can do this through HTTP requests from any language or via our official Python or TypeScript SDK.  To install the official [Python SDK](https://pypi.org/project/humanloop/), run the following command:  ```bash pip install humanloop ```  To install the official [TypeScript SDK](https://www.npmjs.com/package/humanloop), run the following command:  ```bash npm i humanloop ```  ---  Guides and further details about key concepts can be found in [our docs](https://docs.humanloop.com/).

    The version of the OpenAPI document: 4.0.1
    Generated by: https://konfigthis.com
"""

from datetime import datetime, date
import typing
from enum import Enum
from typing_extensions import TypedDict, Literal, TYPE_CHECKING
from pydantic import BaseModel, Field, RootModel

from humanloop.pydantic.session_project_response import SessionProjectResponse

class SessionResponse(BaseModel):
    # String ID of session. Starts with `sesh_`.
    id: str = Field(alias='id')

    # List of projects that have datapoints associated to this session.
    projects: typing.List[SessionProjectResponse] = Field(alias='projects')

    # Number of datapoints associated to this session.
    datapoints_count: int = Field(alias='datapoints_count')

    created_at: datetime = Field(alias='created_at')

    updated_at: datetime = Field(alias='updated_at')

    # Unique user-provided string identifying the session.
    reference_id: typing.Optional[str] = Field(None, alias='reference_id')

    # Inputs for the first datapoint in the session.
    first_inputs: typing.Optional[typing.Dict[str, typing.Union[bool, date, datetime, dict, float, int, list, str, None]]] = Field(None, alias='first_inputs')

    # Output for the last datapoint in the session.
    last_output: typing.Optional[str] = Field(None, alias='last_output')
    class Config:
        arbitrary_types_allowed = True
