# coding: utf-8

"""
    Humanloop API

    The Humanloop API allows you to interact with Humanloop from your product or service.  You can do this through HTTP requests from any language or via our official Python or TypeScript SDK.  To install the official [Python SDK](https://pypi.org/project/humanloop/), run the following command:  ```bash pip install humanloop ```  To install the official [TypeScript SDK](https://www.npmjs.com/package/humanloop), run the following command:  ```bash npm i humanloop ```  ---  Guides and further details about key concepts can be found in [our docs](https://docs.humanloop.com/).

    The version of the OpenAPI document: 4.0.1
    Generated by: https://konfigthis.com
"""

from datetime import datetime, date
import typing
from enum import Enum
from typing_extensions import TypedDict, Literal, TYPE_CHECKING

from humanloop.type.config_response import ConfigResponse
from humanloop.type.dataset_response import DatasetResponse
from humanloop.type.evaluation_status import EvaluationStatus
from humanloop.type.evaluator_response import EvaluatorResponse
from humanloop.type.feedback_aggregate_response import FeedbackAggregateResponse
from humanloop.type.model_config_evaluator_aggregate_response import ModelConfigEvaluatorAggregateResponse

class RequiredEvaluationResponse(TypedDict):
    # Unique ID for the evaluation. Starts with `ev_`.
    id: str

    status: EvaluationStatus

    config: ConfigResponse

    created_at: datetime

    updated_at: datetime

    evaluators: typing.List[EvaluatorResponse]

    dataset: DatasetResponse

class OptionalEvaluationResponse(TypedDict, total=False):
    dataset_snapshot: DatasetResponse

    evaluator_aggregates: typing.List[ModelConfigEvaluatorAggregateResponse]

    feedback_aggregates: FeedbackAggregateResponse

class EvaluationResponse(RequiredEvaluationResponse, OptionalEvaluationResponse):
    pass
