# coding: utf-8

"""
    Humanloop API

    The Humanloop API allows you to interact with Humanloop from your product or service.  You can do this through HTTP requests from any language or via our official Python or TypeScript SDK.  To install the official [Python SDK](https://pypi.org/project/humanloop/), run the following command:  ```bash pip install humanloop ```  To install the official [TypeScript SDK](https://www.npmjs.com/package/humanloop), run the following command:  ```bash npm i humanloop ```  ---  Guides and further details about key concepts can be found in [our docs](https://docs.humanloop.com/).

    The version of the OpenAPI document: 4.0.1
    Generated by: https://konfigthis.com
"""

from datetime import datetime, date
import typing
from enum import Enum
from typing_extensions import TypedDict, Literal, TYPE_CHECKING

from humanloop.type.evaluator_arguments_type import EvaluatorArgumentsType
from humanloop.type.evaluator_return_type_enum import EvaluatorReturnTypeEnum
from humanloop.type.evaluator_type import EvaluatorType
from humanloop.type.model_config_response import ModelConfigResponse
if TYPE_CHECKING:
    from humanloop.type.project_response import ProjectResponse

class RequiredEvaluatorResponse(TypedDict):
    # The description of the evaluator.
    description: str

    # The name of the evaluator.
    name: str

    # Whether this evaluator is target-free or target-required.
    arguments_type: EvaluatorArgumentsType

    # The type of the return value of the evaluator.
    return_type: EvaluatorReturnTypeEnum

    # The type of the evaluator.
    type: EvaluatorType

    # Unique ID for the evaluator. Starts with `evfn_`.
    id: str

    created_at: datetime

    updated_at: datetime

class OptionalEvaluatorResponse(TypedDict, total=False):
    # The code for the evaluator. This code will be executed in a sandboxed environment.
    code: str

    # The model config defining the LLM evaluator.
    model_config: ModelConfigResponse

    # The project where the evaluator logs are stored.
    logging_project: 'ProjectResponse'

class EvaluatorResponse(RequiredEvaluatorResponse, OptionalEvaluatorResponse):
    pass
