# coding: utf-8

"""
    Humanloop API

    The Humanloop API allows you to interact with Humanloop from your product or service.  You can do this through HTTP requests from any language or via our official Python or TypeScript SDK.  To install the official [Python SDK](https://pypi.org/project/humanloop/), run the following command:  ```bash pip install humanloop ```  To install the official [TypeScript SDK](https://www.npmjs.com/package/humanloop), run the following command:  ```bash npm i humanloop ```  ---  Guides and further details about key concepts can be found in [our docs](https://docs.humanloop.com/).

    The version of the OpenAPI document: 4.0.1
    Generated by: https://konfigthis.com
"""

from datetime import datetime, date
import typing
from enum import Enum
from typing_extensions import TypedDict, Literal, TYPE_CHECKING

from humanloop.type.config_response import ConfigResponse

class RequiredExperimentConfigResponse(TypedDict):
    # Number of datapoints with feedback associated to the experiment.
    trials_count: int

    # Whether the model config is active in the experiment. Only active model configs can be sampled from the experiment.
    active: bool

    # String ID of model config. Starts with `config_`.
    id: str

    # Display name of model config. If this is not set by the user, a friendly name is generated.
    display_name: str

    # Definition of the config used in the experiment.
    config: ConfigResponse

    created_at: datetime

    updated_at: datetime

class OptionalExperimentConfigResponse(TypedDict, total=False):
    # The mean performance of the model config.
    mean: typing.Union[int, float]

    # The spread of performance of the model config.
    spread: typing.Union[int, float]

class ExperimentConfigResponse(RequiredExperimentConfigResponse, OptionalExperimentConfigResponse):
    pass
