# coding: utf-8

"""
    Humanloop API

    The Humanloop API allows you to interact with Humanloop from your product or service.  You can do this through HTTP requests from any language or via our official Python or TypeScript SDK.  To install the official [Python SDK](https://pypi.org/project/humanloop/), run the following command:  ```bash pip install humanloop ```  To install the official [TypeScript SDK](https://www.npmjs.com/package/humanloop), run the following command:  ```bash npm i humanloop ```  ---  Guides and further details about key concepts can be found in [our docs](https://docs.humanloop.com/).

    The version of the OpenAPI document: 4.0.1
    Generated by: https://konfigthis.com
"""

from datetime import datetime, date
import typing
from enum import Enum
from typing_extensions import TypedDict, Literal, TYPE_CHECKING

from humanloop.type.base_metric_response import BaseMetricResponse
from humanloop.type.experiment_config_response import ExperimentConfigResponse
from humanloop.type.experiment_status import ExperimentStatus
from humanloop.type.positive_label import PositiveLabel

class RequiredExperimentResponse(TypedDict):
    # String ID of experiment. Starts with `exp_`.
    id: str

    # String ID of project the experiment belongs to. Starts with `pr_`.
    project_id: str

    # Name of experiment.
    name: str

    # Status of experiment.
    status: ExperimentStatus

    # Metric used as the experiment's objective.
    metric: BaseMetricResponse

    # Feedback labels to treat as positive user feedback. Used to monitor the performance of model configs in the experiment.
    positive_labels: typing.List[PositiveLabel]

    created_at: datetime

    updated_at: datetime

class OptionalExperimentResponse(TypedDict, total=False):
    # List of configs associated to the experiment.
    configs: typing.List[ExperimentConfigResponse]

class ExperimentResponse(RequiredExperimentResponse, OptionalExperimentResponse):
    pass
