# coding: utf-8

"""
    Humanloop API

    The Humanloop API allows you to interact with Humanloop from your product or service.  You can do this through HTTP requests from any language or via our official Python or TypeScript SDK.  To install the official [Python SDK](https://pypi.org/project/humanloop/), run the following command:  ```bash pip install humanloop ```  To install the official [TypeScript SDK](https://www.npmjs.com/package/humanloop), run the following command:  ```bash npm i humanloop ```  ---  Guides and further details about key concepts can be found in [our docs](https://docs.humanloop.com/).

    The version of the OpenAPI document: 4.0.1
    Generated by: https://konfigthis.com
"""

from datetime import datetime, date
import typing
from enum import Enum
from typing_extensions import TypedDict, Literal, TYPE_CHECKING

from humanloop.type.feedback_type import FeedbackType

class RequiredFeedbackResponse(TypedDict):
    # The type of feedback. The default feedback types available are 'rating', 'action', 'issue', 'correction', and 'comment'.
    type: typing.Union[FeedbackType, str]

    # The feedback value to set. This would be the appropriate text for 'correction' or 'comment', or a label to apply for 'rating', 'action', or 'issue'.
    value: typing.Union[typing.Union[int, float], str]

    # String ID of user feedback. Starts with `ann_`, short for annotation.
    id: str

class OptionalFeedbackResponse(TypedDict, total=False):
    # ID to associate the feedback to a previously logged datapoint.
    data_id: str

    # A unique identifier to who provided the feedback.
    user: str

    # User defined timestamp for when the feedback was created. 
    created_at: datetime

class FeedbackResponse(RequiredFeedbackResponse, OptionalFeedbackResponse):
    pass
