# coding: utf-8

"""
    Humanloop API

    The Humanloop API allows you to interact with Humanloop from your product or service.  You can do this through HTTP requests from any language or via our official Python or TypeScript SDK.  To install the official [Python SDK](https://pypi.org/project/humanloop/), run the following command:  ```bash pip install humanloop ```  To install the official [TypeScript SDK](https://www.npmjs.com/package/humanloop), run the following command:  ```bash npm i humanloop ```  ---  Guides and further details about key concepts can be found in [our docs](https://docs.humanloop.com/).

    The version of the OpenAPI document: 4.0.1
    Generated by: https://konfigthis.com
"""

from datetime import datetime, date
import typing
from enum import Enum
from typing_extensions import TypedDict, Literal, TYPE_CHECKING

from humanloop.type.dataset_response import DatasetResponse
from humanloop.type.finetune_config import FinetuneConfig

class RequiredFinetuneResponse(TypedDict):
    # Unique identifier for fine-tuned model.
    id: str

    # User defined friendly name for a fine-tuning run
    name: str

    # The fine-tuning process is run async and so the resultingfine-tuned model won't be available for generations until it has completed.
    status: str

    # Configuration details for the fine-tuned model.
    config: FinetuneConfig

    dataset: DatasetResponse

    created_at: datetime

    updated_at: datetime

class OptionalFinetuneResponse(TypedDict, total=False):
    # Unique reference for the fine-tuned required to make calls to the provider.
    model_name: str

    # Any additional metadata that you would like to log for reference.
    metadata: typing.Dict[str, typing.Union[bool, date, datetime, dict, float, int, list, str, None]]

    # Unique ID for the fine-tuned model required to make calls to the provider's API.
    provider_id: str

    # Provider specific fine-tuning results.
    provider_details: typing.Dict[str, typing.Union[bool, date, datetime, dict, float, int, list, str, None]]

    # Summary stats about the data used for finetuning.
    data_summary: typing.Dict[str, typing.Union[bool, date, datetime, dict, float, int, list, str, None]]

class FinetuneResponse(RequiredFinetuneResponse, OptionalFinetuneResponse):
    pass
