# coding: utf-8

"""
    Humanloop API

    The Humanloop API allows you to interact with Humanloop from your product or service.  You can do this through HTTP requests from any language or via our official Python or TypeScript SDK.  To install the official [Python SDK](https://pypi.org/project/humanloop/), run the following command:  ```bash pip install humanloop ```  To install the official [TypeScript SDK](https://www.npmjs.com/package/humanloop), run the following command:  ```bash npm i humanloop ```  ---  Guides and further details about key concepts can be found in [our docs](https://docs.humanloop.com/).

    The version of the OpenAPI document: 4.0.1
    Generated by: https://konfigthis.com
"""

from datetime import datetime, date
import typing
from enum import Enum
from typing_extensions import TypedDict, Literal, TYPE_CHECKING

from humanloop.type.chat_message_with_tool_call import ChatMessageWithToolCall
from humanloop.type.config_response import ConfigResponse
from humanloop.type.evaluation_result_response import EvaluationResultResponse
from humanloop.type.feedback_response import FeedbackResponse
from humanloop.type.metric_value_response import MetricValueResponse
from humanloop.type.observability_status import ObservabilityStatus
from humanloop.type.tool_choice import ToolChoice
from humanloop.type.tool_result_response import ToolResultResponse

class RequiredLogResponse(TypedDict):
    # String ID of logged datapoint. Starts with `data_`.
    id: str

    config: ConfigResponse

    evaluation_results: typing.List[EvaluationResultResponse]

    observability_status: ObservabilityStatus

    updated_at: datetime

class OptionalLogResponse(TypedDict, total=False):
    # The name of the project associated with this log
    project: str

    # The unique ID of the project associated with this log.
    project_id: str

    # ID of the session to associate the datapoint.
    session_id: str

    # A unique string identifying the session to associate the datapoint to. Allows you to log multiple datapoints to a session (using an ID kept by your internal systems) by passing the same `session_reference_id` in subsequent log requests. Specify at most one of this or `session_id`.
    session_reference_id: str

    # ID associated to the parent datapoint in a session.
    parent_id: str

    # A unique string identifying the previously-logged parent datapoint in a session. Allows you to log nested datapoints with your internal system IDs by passing the same reference ID as `parent_id` in a prior log request. Specify at most one of this or `parent_id`. Note that this cannot refer to a datapoint being logged in the same request.
    parent_reference_id: str

    # The inputs passed to the prompt template.
    inputs: typing.Dict[str, typing.Union[bool, date, datetime, dict, float, int, list, str, None]]

    # Identifies where the model was called from.
    source: str

    # Any additional metadata to record.
    metadata: typing.Dict[str, typing.Union[bool, date, datetime, dict, float, int, list, str, None]]

    # Whether the request/response payloads will be stored on Humanloop.
    save: bool

    # ID of the source datapoint if this is a log derived from a datapoint in a dataset.
    source_datapoint_id: str

    # Unique user-provided string identifying the datapoint.
    reference_id: str

    # Unique ID of an experiment trial to associate to the log.
    trial_id: str

    # The messages passed to the to provider chat endpoint.
    messages: typing.List[ChatMessageWithToolCall]

    # Generated output from your model for the provided inputs. Can be `None` if logging an error, or if logging a parent datapoint with the intention to populate it later
    output: str

    # Unique ID of a config to associate to the log.
    config_id: str

    # The environment name used to create the log.
    environment: str

    feedback: typing.List[FeedbackResponse]

    # User defined timestamp for when the log was created. 
    created_at: datetime

    # Error message if the log is an error.
    error: str

    # Duration of the logged event in seconds.
    duration: typing.Union[int, float]

    # The message returned by the provider.
    output_message: ChatMessageWithToolCall

    # Number of tokens in the prompt used to generate the output.
    prompt_tokens: int

    # Number of tokens in the output generated by the model.
    output_tokens: int

    # Raw request sent to provider.
    provider_request: typing.Dict[str, typing.Union[bool, date, datetime, dict, float, int, list, str, None]]

    # Raw response received the provider.
    provider_response: typing.Dict[str, typing.Union[bool, date, datetime, dict, float, int, list, str, None]]

    # User email address provided when creating the datapoint.
    user: str

    # Latency of provider response.
    provider_latency: typing.Union[int, float]

    # Total number of tokens in the prompt and output.
    tokens: int

    # Raw output from the provider.
    raw_output: str

    # Reason the generation finished.
    finish_reason: str

    metric_values: typing.List[MetricValueResponse]

    tools: typing.List[ToolResultResponse]

    # Controls how the model uses tools. The following options are supported: 'none' forces the model to not call a tool; the default when no tools are provided as part of the model config. 'auto' the model can decide to call one of the provided tools; the default when tools are provided as part of the model config. Providing {'type': 'function', 'function': {name': <TOOL_NAME>}} forces the model to use the named function.
    tool_choice: typing.Union[str, str, ToolChoice]

class LogResponse(RequiredLogResponse, OptionalLogResponse):
    pass
